/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.keyvault.secret.runtime.config;

import com.azure.security.keyvault.secrets.models.KeyVaultSecretIdentifier;

public class KeyVaultSecretConfigUtil {
    private static final String AZURE_KEYVAULT_PREFIX = "kv//";
    private static final String AZURE_KEYVAULT_ENDPOINT_PREFIX = "https://";
    private static final String AZURE_VAULT_URL_FORMAT = "https://%s.%s/secrets/%s/%s";
    private static final String AZURE_CLOUD_DNS = "vault.azure.net";

    private KeyVaultSecretConfigUtil() {
    }

    static KeyVaultSecretIdentifier getSecretIdentifier(String input, String defaultEndpoint) {
        if (!input.startsWith(AZURE_KEYVAULT_PREFIX)) {
            return null;
        }
        String resourcePath = input.substring(AZURE_KEYVAULT_PREFIX.length());
        String[] tokens = resourcePath.split("/");
        String kvName = null;
        String secretName = null;
        String version = "latest";
        if (tokens.length == 1) {
            kvName = KeyVaultSecretConfigUtil.getAzureKeyVaultName(defaultEndpoint);
            secretName = tokens[0];
        } else if (tokens.length == 2) {
            kvName = tokens[0];
            secretName = tokens[1];
        } else if (tokens.length == 3 && tokens[1].equals("secrets")) {
            kvName = tokens[0];
            secretName = tokens[2];
        } else if (tokens.length == 3 && tokens[1].equals("versions")) {
            kvName = KeyVaultSecretConfigUtil.getAzureKeyVaultName(defaultEndpoint);
            secretName = tokens[0];
            version = tokens[2];
        } else if (tokens.length == 4 && tokens[1].equals("secrets")) {
            kvName = tokens[0];
            secretName = tokens[2];
            version = tokens[3];
        } else if (tokens.length == 5 && tokens[1].equals("secrets") && tokens[3].equals("versions")) {
            kvName = tokens[0];
            secretName = tokens[2];
            version = tokens[4];
        } else {
            throw new IllegalArgumentException("Unrecognized format for specifying an Azure Key Vault secret: " + input);
        }
        if (kvName.isEmpty() || secretName.isEmpty() || version.isEmpty()) {
            throw new IllegalArgumentException("The provided Key Vault secret URI is invalid: " + input);
        }
        return new KeyVaultSecretIdentifier(String.format(AZURE_VAULT_URL_FORMAT, kvName, KeyVaultSecretConfigUtil.getKeyValutDNS(defaultEndpoint), secretName, version));
    }

    static String getAzureKeyVaultName(String endpoint) {
        assert (!endpoint.isEmpty()) : "The endpoint of Azure Key Vault should be set.";
        assert (endpoint.startsWith(AZURE_KEYVAULT_ENDPOINT_PREFIX)) : "The endpoint of Azure Key Vault should start with https://.";
        return endpoint.substring(AZURE_KEYVAULT_ENDPOINT_PREFIX.length()).split("\\.")[0];
    }

    static String getKeyValutDNS(String endpoint) {
        if (endpoint.isEmpty()) {
            return AZURE_CLOUD_DNS;
        }
        String kvName = KeyVaultSecretConfigUtil.getAzureKeyVaultName(endpoint);
        String dns = endpoint.substring(kvName.length() + AZURE_KEYVAULT_ENDPOINT_PREFIX.length()).split("/")[0];
        return dns.length() > 1 ? dns.substring(1) : AZURE_CLOUD_DNS;
    }
}

