/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.keyvault.secret.runtime;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import io.quarkiverse.azure.keyvault.secret.runtime.config.KeyVaultSecretConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

public class KeyVaultSecretClientProducer {
    @Inject
    KeyVaultSecretConfig secretConfiguration;

    @Produces
    public SecretClient createSecretClient() {
        if (!this.secretConfiguration.enabled()) {
            return null;
        }
        String endpoint = this.secretConfiguration.endpoint().orElseThrow(() -> new ConfigurationException("The endpoint of Azure Key Vault Secret (quarkus.azure.keyvault.secret.endpoint) must be set"));
        return new SecretClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-kv-secret-sync")).vaultUrl(endpoint).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildClient();
    }

    @Produces
    public SecretAsyncClient createSecretAsyncClient() {
        if (!this.secretConfiguration.enabled()) {
            return null;
        }
        String endpoint = this.secretConfiguration.endpoint().orElseThrow(() -> new ConfigurationException("The endpoint of Azure Key Vault Secret must be set"));
        return new SecretClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-kv-secret-async")).vaultUrl(endpoint).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildAsyncClient();
    }
}

