/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.storage.blob.deployment;

import io.quarkiverse.azure.storage.blob.deployment.DevServicesConfig;
import io.quarkiverse.azure.storage.blob.deployment.StorageBlobBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DevServicesStorageBlobProcessor {
    static final String IMAGE = "mcr.microsoft.com/azure-storage/azurite:3.33.0";
    private static final Logger log = Logger.getLogger(DevServicesStorageBlobProcessor.class);
    private static final int EXPOSED_PORT = 10000;
    private static final String PROTOCOL = "http";
    private static final String ACCOUNT_NAME = "devstoreaccount1";
    private static final String ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String CONFIG_KEY_CONNECTION_STRING = "quarkus.azure.storage.blob.connection-string";
    private static final String CONFIG_KEY_ENDPOINT = "quarkus.azure.storage.blob.endpoint";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-azure-storage-blob";
    private static final ContainerLocator containerLocator = new ContainerLocator("quarkus-dev-service-azure-storage-blob", 10000);
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile DevServicesConfig capturedDevServicesConfiguration;
    private static volatile boolean first;

    public static String getBlobEndpoint(String host, int port) {
        return String.format("%s://%s:%s/%s", PROTOCOL, host, port, ACCOUNT_NAME);
    }

    public static String getConnectionString(String host, int port) {
        String blobEndpoint = DevServicesStorageBlobProcessor.getBlobEndpoint(host, port);
        return String.format("DefaultEndpointsProtocol=%s;AccountName=%s;AccountKey=%s;BlobEndpoint=%s;", PROTOCOL, ACCOUNT_NAME, ACCOUNT_KEY, blobEndpoint);
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startStorageBlobContainer(BuildProducer<DevServicesResultBuildItem> devConfig, LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, StorageBlobBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (devService != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return;
            }
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Azurite storage blob container", e);
            }
            devService = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Azure Storage Blob Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startContainer(dockerStatusBuildItem, currentDevServicesConfiguration, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService != null) {
                devConfig.produce((BuildItem)devService.toBuildItem());
                log.infof("The Azurite storage blob container %s is ready to accept connections", (Object)devService.getContainerId());
            }
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    try {
                        devService.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Failed to stop Azurite storage blob container", t);
                    }
                    devService = null;
                }
                first = true;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.info((Object)"Not starting devservice for Azure storage blob client as it has been disabled in the config");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)CONFIG_KEY_CONNECTION_STRING) && !ConfigUtils.isPropertyPresent((String)CONFIG_KEY_ENDPOINT);
        if (!needToStart) {
            log.info((Object)"Not starting devservice for Azure storage blob client as host has been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Please configure quarkus.azure.storage.blob.connection-string for Azure storage blob client or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(IMAGE)).asCompatibleSubstituteFor(IMAGE);
        Supplier<DevServicesResultBuildItem.RunningDevService> storageBlobServerSupplier = () -> {
            QuarkusPortAzuriteContainer azuriteContainer = new QuarkusPortAzuriteContainer(dockerImageName, devServicesConfig.port, launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusPortAzuriteContainer)azuriteContainer).withStartupTimeout(arg_0));
            azuriteContainer.start();
            return new DevServicesResultBuildItem.RunningDevService("azure-storage-blob", azuriteContainer.getContainerId(), () -> ((QuarkusPortAzuriteContainer)azuriteContainer).close(), CONFIG_KEY_CONNECTION_STRING, DevServicesStorageBlobProcessor.getConnectionString(azuriteContainer.getHost(), azuriteContainer.getPort()));
        };
        return containerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> new DevServicesResultBuildItem.RunningDevService("azure-storage-blob", containerAddress.getId(), null, CONFIG_KEY_CONNECTION_STRING, DevServicesStorageBlobProcessor.getConnectionString(containerAddress.getHost(), containerAddress.getPort()))).orElseGet(storageBlobServerSupplier);
    }

    static {
        first = true;
    }

    private static class QuarkusPortAzuriteContainer
    extends GenericContainer<QuarkusPortAzuriteContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusPortAzuriteContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(DevServicesStorageBlobProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"azure-storage-blob");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 10000);
            } else {
                this.addExposedPort(10000);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 10000;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

