/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.storage.blob.runtime;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import io.quarkiverse.azure.storage.blob.runtime.StorageBlobConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

public class StorageBlobServiceClientProducer {
    @Inject
    StorageBlobConfig storageBlobConfiguration;

    @Produces
    public BlobServiceClient blobServiceClient() {
        BlobServiceClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildClient();
    }

    @Produces
    public BlobServiceAsyncClient blobServiceAsyncClient() {
        BlobServiceClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildAsyncClient();
    }

    private BlobServiceClientBuilder getBuilder() {
        if (!this.storageBlobConfiguration.enabled()) {
            return null;
        }
        if (this.storageBlobConfiguration.endpoint().isEmpty() && this.storageBlobConfiguration.connectionString().isEmpty()) {
            throw new ConfigurationException("The endpoint (quarkus.azure.storage.blob.endpoint) or connection string (quarkus.azure.storage.blob.connection-string) of Azure Storage blob must be set");
        }
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-storage-blob"));
        if (this.storageBlobConfiguration.connectionString().isPresent()) {
            return builder.connectionString(this.storageBlobConfiguration.connectionString().get());
        }
        return builder.endpoint(this.storageBlobConfiguration.endpoint().get()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
    }
}

