/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.barcode.deployment.barcode4j;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.logging.Log;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import org.krysalis.barcode4j.output.bitmap.ImageIOBitmapEncoder;

class Barcode4JProcessor {
    private static final String FEATURE = "barcode4j";

    Barcode4JProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.barcode4j", FEATURE));
    }

    @BuildStep
    void runtimeBarcodeInitializedClasses(BuildProducer<RuntimeInitializedPackageBuildItem> runtimeInitializedPackages) {
        ArrayList<String> classes = new ArrayList<String>(Stream.of(BitmapEncoderRegistry.class.getName(), "javax.swing.plaf.metal", "javax.swing.text.html", "javax.swing.text.rtf", "sun.datatransfer", "sun.swing").toList());
        Log.debugf((String)"Barcode4J Runtime: %s", classes);
        classes.stream().map(RuntimeInitializedPackageBuildItem::new).forEach(arg_0 -> runtimeInitializedPackages.produce(arg_0));
    }

    @BuildStep
    void registerBarcodeForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add("javax.imageio.ImageIO");
        classNames.add(ImageIOBitmapEncoder.class.getName());
        Log.debugf((String)"Barcode4J Reflection: %s", classNames);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods().fields().serialization().build());
    }

    @BuildStep
    void registerBarcodeResources(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/krysalis/barcode4j/impl/fourstate/usps-4bc-bar-to-character-table.csv"}));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.krysalis.barcode4j.impl.code128.EAN128AIs"));
    }
}

