/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.barcode.okapi;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.Code93;
import uk.org.okapibarcode.backend.DataMatrix;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.QrCode;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.Upc;
import uk.org.okapibarcode.graphics.Color;
import uk.org.okapibarcode.output.Java2DRenderer;
import uk.org.okapibarcode.output.PostScriptRenderer;
import uk.org.okapibarcode.output.SvgRenderer;

public class Okapi {
    private Okapi() {
    }

    public static BufferedImage code128(String value, int width, int height) {
        Code128 code128 = new Code128();
        code128.setContent(value);
        return Okapi.generateBarcodePng((Symbol)code128, width, height);
    }

    public static String code128Png(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.code128(value, width, height));
    }

    public static String code128Svg(String value, double magnification) {
        Code128 code128 = new Code128();
        code128.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)code128, magnification));
    }

    public static BufferedImage code39(String value, int width, int height) {
        Code3Of9 code39 = new Code3Of9();
        code39.setContent(value);
        return Okapi.generateBarcodePng((Symbol)code39, width, height);
    }

    public static String code39Png(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.code39(value, width, height));
    }

    public static String code39Svg(String value, double magnification) {
        Code3Of9 code39 = new Code3Of9();
        code39.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)code39, magnification));
    }

    public static BufferedImage code93(String value, int width, int height) {
        Code93 code93 = new Code93();
        code93.setContent(value);
        return Okapi.generateBarcodePng((Symbol)code93, width, height);
    }

    public static String code93Png(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.code93(value, width, height));
    }

    public static String code93Svg(String value, double magnification) {
        Code93 code93 = new Code93();
        code93.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)code93, magnification));
    }

    public static BufferedImage ean13(String value, int width, int height) {
        Ean ean13 = new Ean(Ean.Mode.EAN13);
        ean13.setContent(value);
        return Okapi.generateBarcodePng((Symbol)ean13, width, height);
    }

    public static String ean13Png(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.ean13(value, width, height));
    }

    public static String ean13Svg(String value, double magnification) {
        Ean ean13 = new Ean(Ean.Mode.EAN13);
        ean13.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)ean13, magnification));
    }

    public static BufferedImage ean8(String value, int width, int height) {
        Ean ean8 = new Ean(Ean.Mode.EAN8);
        ean8.setContent(value);
        return Okapi.generateBarcodePng((Symbol)ean8, width, height);
    }

    public static String ean8Png(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.ean8(value, width, height));
    }

    public static String ean8Svg(String value, double magnification) {
        Ean ean8 = new Ean(Ean.Mode.EAN8);
        ean8.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)ean8, magnification));
    }

    public static BufferedImage upcA(String value, int width, int height) {
        Upc upcA = new Upc(Upc.Mode.UPCA);
        upcA.setContent(value);
        return Okapi.generateBarcodePng((Symbol)upcA, width, height);
    }

    public static String upcAPng(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.upcA(value, width, height));
    }

    public static String upcASvg(String value, double magnification) {
        Upc upcA = new Upc(Upc.Mode.UPCA);
        upcA.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)upcA, magnification));
    }

    public static BufferedImage qrCode(String value, int width, int height) {
        QrCode qrCode = new QrCode();
        qrCode.setContent(value);
        return Okapi.generateBarcodePng((Symbol)qrCode, width, height);
    }

    public static String qrCodePng(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.qrCode(value, width, height));
    }

    public static String qrCodeSvg(String value, double magnification) {
        QrCode qrCode = new QrCode();
        qrCode.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)qrCode, magnification));
    }

    public static BufferedImage dataMatrix(String value, int width, int height) {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setContent(value);
        return Okapi.generateBarcodePng((Symbol)dataMatrix, width, height);
    }

    public static String dataMatrixPng(String value, int width, int height) {
        return Okapi.dataUriPng(Okapi.dataMatrix(value, width, height));
    }

    public static String dataMatrixSvg(String value, double magnification) {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setContent(value);
        return Okapi.dataUriSvg(Okapi.generateBarcodeSvg((Symbol)dataMatrix, magnification));
    }

    public static String generateBarcodeSvgAsString(Symbol symbol) {
        return new String(Okapi.generateBarcodeSvg(symbol, 1.0), StandardCharsets.UTF_8);
    }

    public static byte[] generateBarcodeSvg(Symbol symbol) {
        return Okapi.generateBarcodeSvg(symbol, 1.0);
    }

    public static byte[] generateBarcodeSvg(Symbol symbol, double magnification) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SvgRenderer renderer = new SvgRenderer((OutputStream)out, magnification, Color.WHITE, Color.BLACK, true);
        try {
            renderer.render(symbol);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static String generateBarcodePostscriptAsString(Symbol symbol) {
        return new String(Okapi.generateBarcodePostscript(symbol, 1.0), StandardCharsets.UTF_8);
    }

    public static byte[] generateBarcodePostscript(Symbol symbol, double magnification) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PostScriptRenderer renderer = new PostScriptRenderer((OutputStream)out, magnification, Color.WHITE, Color.BLACK);
        try {
            renderer.render(symbol);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static BufferedImage generateBarcodePng(Symbol symbol, int width, int height) {
        return Okapi.generateBarcodePng(symbol, width, height, 1.0);
    }

    public static BufferedImage generateBarcodePng(Symbol symbol, int width, int height, double magnification) {
        BufferedImage image = new BufferedImage(width, height, 10);
        Graphics2D g2d = image.createGraphics();
        Java2DRenderer renderer = new Java2DRenderer(g2d, magnification, Color.WHITE, Color.BLACK);
        renderer.render(symbol);
        g2d.dispose();
        return image;
    }

    public static String dataUriPng(BufferedImage image) {
        return Okapi.base64ToDataUri(Okapi.pngToBase64(image), "image/png");
    }

    public static String dataUriSvg(byte[] bytes) {
        String base64 = Okapi.bytesToBase64(bytes);
        return Okapi.base64ToDataUri(base64, "image/svg+xml");
    }

    public static byte[] pngToBytes(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static String pngToBase64(BufferedImage image) {
        return Okapi.bytesToBase64(new String(Okapi.pngToBytes(image), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
    }

    public static String bytesToBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String base64ToDataUri(String base64, String mimeType) {
        return "data:%s;base64,%s".formatted(mimeType, base64);
    }
}

