/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.quarkiverse.bucket4j.runtime.resolver.IdentityResolver;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;

public class BucketPod {
    private final String id;
    private final Class<? extends IdentityResolver> identityResolver;
    final BucketConfiguration configuration;

    public BucketPod(String id, BucketConfiguration configuration, Class<? extends IdentityResolver> identityResolver) {
        this.id = id;
        this.configuration = configuration;
        this.identityResolver = identityResolver;
    }

    public String getId() {
        return this.id;
    }

    public long consumeAndReturnNanoWaitTime() {
        return this.getBucket().tryConsumeAndReturnRemaining(1L).getNanosToWaitForRefill();
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public IdentityResolver getIdentityResolver() {
        return (IdentityResolver)CDI.current().select(this.identityResolver, new Annotation[0]).get();
    }

    ProxyManager<String> getProxyManager() {
        return (ProxyManager)CDI.current().select((TypeLiteral)new TypeLiteral<ProxyManager<String>>(){}, new Annotation[0]).get();
    }

    Bucket getBucket() {
        return this.getProxyManager().builder().build((Object)(this.getId() + "_" + this.getIdentityResolver().getIdentityKey()), this::getConfiguration);
    }
}

