/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.certmanager.deployment.utils;

import io.dekorate.utils.Maps;
import io.quarkiverse.certmanager.deployment.CertificateConfig;
import io.quarkiverse.certmanager.deployment.SubjectConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class CertManagerConfigUtil {
    private static final String QUARKUS_PREFIX = "quarkus.certificate.";
    private static final String MULTIPART_SEPARATOR_PATTERN = Pattern.quote(".");

    private CertManagerConfigUtil() {
    }

    public static Map<String, Object> transformToDekorateProperties(String name, CertificateConfig certificateConfig) {
        Config config = ConfigProvider.getConfig();
        Map<String, Object> certificateProperties = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> k.startsWith(QUARKUS_PREFIX)).collect(Collectors.toMap(k -> k.replaceFirst(QUARKUS_PREFIX, ""), k -> config.getValue(k, String.class)));
        certificateProperties = CertManagerConfigUtil.expandProperties(certificateProperties);
        CertManagerConfigUtil.overwriteNonStringProperties(certificateConfig, certificateProperties);
        certificateProperties.putIfAbsent("name", name);
        return certificateProperties;
    }

    private static void overwriteNonStringProperties(CertificateConfig config, Map<String, Object> props) {
        config.dnsNames().ifPresent(l -> CertManagerConfigUtil.put(props, "dns-names", l));
        config.ipAddresses().ifPresent(l -> CertManagerConfigUtil.put(props, "ip-addresses", l));
        config.uris().ifPresent(l -> CertManagerConfigUtil.put(props, "uris", l));
        config.emailAddresses().ifPresent(l -> CertManagerConfigUtil.put(props, "email-addresses", l));
        config.usages().ifPresent(l -> CertManagerConfigUtil.put(props, "usages", l));
        if (config.ca().isPresent()) {
            Map caProps = (Map)props.get("ca");
            config.ca().get().crlDistributionPoints().ifPresent(l -> CertManagerConfigUtil.put(caProps, "crl-distribution-points", l));
        }
        if (config.selfSigned().isPresent()) {
            Map ssProps = (Map)props.get("self-signed");
            config.selfSigned().get().crlDistributionPoints().ifPresent(l -> CertManagerConfigUtil.put(ssProps, "crl-distribution-points", l));
        }
        if (config.subject().isPresent()) {
            Map subjectProps = (Map)props.get("subject");
            SubjectConfig subjectConfig = config.subject().get();
            subjectConfig.organizations().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "organizations", l));
            subjectConfig.countries().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "countries", l));
            subjectConfig.organizationalUnits().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "organizational-units", l));
            subjectConfig.localities().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "localities", l));
            subjectConfig.provinces().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "provinces", l));
            subjectConfig.streetAddresses().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "street-addresses", l));
            subjectConfig.postalCodes().ifPresent(l -> CertManagerConfigUtil.put(subjectProps, "postal-codes", l));
        }
        if (config.privateKey().isPresent()) {
            Map privateKeyProps = (Map)props.get("private-key");
            privateKeyProps.put("size", config.privateKey().get().size());
        }
    }

    private static Map<String, Object> expandProperties(Map<String, Object> properties) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        for (String propertyName : properties.keySet()) {
            Object value = properties.get(propertyName);
            String[] parts = propertyName.split(MULTIPART_SEPARATOR_PATTERN);
            if (parts.length == 1) {
                newProperties.put(propertyName, value);
                continue;
            }
            Map<String, Object> nestedProperties = CertManagerConfigUtil.asMap(parts, value);
            Maps.merge(newProperties, nestedProperties);
        }
        return newProperties;
    }

    private static void put(Map<String, Object> map, String key, List<String> value) {
        map.put(key, value.toArray(new String[0]));
    }

    private static Map<String, Object> asMap(String[] keys, Object value) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (keys.length == 1) {
            result.put(keys[0], value);
            return result;
        }
        String key = keys[0];
        String[] remaining = new String[keys.length - 1];
        System.arraycopy(keys, 1, remaining, 0, remaining.length);
        Map<String, Object> nested = CertManagerConfigUtil.asMap(remaining, value);
        result.put(key, nested);
        return result;
    }
}

