/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.runtime.configuration.PathConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.consul-config")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface ConsulConfig {
    @WithDefault(value="false")
    public boolean enabled();

    public AgentConfig agent();

    public Optional<String> prefix();

    public Optional<List<String>> rawValueKeys();

    public Optional<List<String>> propertiesValueKeys();

    @WithDefault(value="true")
    public boolean failOnMissingKey();

    @ConfigGroup
    public static interface AgentConfig {
        @WithDefault(value="localhost:8500")
        @WithConverter(value=InetSocketAddressConverter.class)
        public InetSocketAddress hostPort();

        @WithDefault(value="false")
        public boolean useHttps();

        public Optional<String> token();

        @WithConverter(value=PathConverter.class)
        public Optional<Path> trustStore();

        public Optional<String> trustStorePassword();

        @WithConverter(value=PathConverter.class)
        public Optional<Path> keyStore();

        public Optional<String> keyStorePassword();

        public Optional<String> keyPassword();

        @WithDefault(value="false")
        public boolean trustCerts();

        @WithDefault(value="10s")
        @WithConverter(value=DurationConverter.class)
        public Duration connectionTimeout();

        @WithDefault(value="60s")
        @WithConverter(value=DurationConverter.class)
        public Duration readTimeout();
    }
}

