/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.Response;
import io.quarkus.consul.config.runtime.ValueType;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

class ResponseConfigSourceUtil {
    private static final Logger log = Logger.getLogger(ResponseConfigSourceUtil.class);
    private static final int ORDINAL = 270;

    ResponseConfigSourceUtil() {
    }

    public static ConfigSource toConfigSource(Response response, ValueType valueType, Optional<String> prefix) {
        MapBackedConfigSource result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to convert data of key  '" + response.getKey() + "' to a list of ConfigSource objects"));
        }
        String keyWithoutPrefix = ResponseConfigSourceUtil.keyWithoutPrefix(response, prefix);
        if (valueType == ValueType.RAW) {
            result = new ConsulSingleValueConfigSource(keyWithoutPrefix, response.getDecodedValue(), 270);
        } else if (valueType == ValueType.PROPERTIES) {
            result = new ConsulPropertiesConfigSource(keyWithoutPrefix, response.getDecodedValue(), 270);
        } else {
            throw new IllegalArgumentException("Consul config value type '" + valueType + "' not supported");
        }
        log.debug((Object)("Done converting data of key '" + response.getKey() + "' into a ConfigSource"));
        return result;
    }

    private static String keyWithoutPrefix(Response response, Optional<String> prefix) {
        return prefix.isPresent() ? response.getKey().replace(prefix.get() + "/", "") : response.getKey();
    }

    private static class ConsulPropertiesConfigSource
    extends MapBackedConfigSource {
        private static final String NAME_FORMAT = "ConsulPropertiesConfigSource[key=%s]";

        ConsulPropertiesConfigSource(String key, String input, int ordinal) {
            super(String.format(NAME_FORMAT, key), ConsulPropertiesConfigSource.readProperties(input), ordinal);
        }

        private static Map<String, String> readProperties(String rawData) {
            StringReader br = new StringReader(rawData);
            try {
                Properties properties = new Properties();
                properties.load(br);
                Properties properties2 = properties;
                br.close();
                return properties2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private static final class ConsulSingleValueConfigSource
    extends MapBackedConfigSource {
        private static final String NAME_PREFIX = "ConsulSingleValueConfigSource[key=";

        public ConsulSingleValueConfigSource(String key, String value, int ordinal) {
            super(NAME_PREFIX + key + "]", Collections.singletonMap(ConsulSingleValueConfigSource.effectiveKey(key), value), ordinal);
        }

        private static String effectiveKey(String key) {
            return key.replace('/', '.');
        }
    }
}

