/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ConsulConfig;
import io.quarkus.consul.config.runtime.ConsulConfigGateway;
import io.quarkus.consul.config.runtime.Response;
import io.smallrye.mutiny.Uni;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.jboss.logging.Logger;

public class VertxConsulConfigGateway
implements ConsulConfigGateway {
    private static final Logger log = Logger.getLogger(VertxConsulConfigGateway.class);
    private static final String PKS_12 = "PKS12";
    private static final String JKS = "JKS";
    private final ConsulConfig consulConfig;
    private final Vertx vertx;
    private final WebClient webClient;

    public VertxConsulConfigGateway(ConsulConfig consulConfig) {
        this.consulConfig = consulConfig;
        this.vertx = this.createVertxInstance();
        this.webClient = VertxConsulConfigGateway.createHttpClient(this.vertx, consulConfig.agent());
    }

    private Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions());
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }

    public static WebClient createHttpClient(Vertx vertx, ConsulConfig.AgentConfig agentConfig) {
        WebClientOptions webClientOptions = new WebClientOptions().setConnectTimeout((int)agentConfig.connectionTimeout().toMillis()).setIdleTimeout((int)agentConfig.readTimeout().getSeconds());
        boolean trustAll = agentConfig.trustCerts();
        try {
            if (agentConfig.trustStore().isPresent()) {
                Path trustStorePath = agentConfig.trustStore().get();
                String type = VertxConsulConfigGateway.determineStoreType(trustStorePath);
                KeyStoreOptionsBase storeOptions = VertxConsulConfigGateway.storeOptions(trustStorePath, agentConfig.trustStorePassword(), VertxConsulConfigGateway.createStoreOptions(type));
                if (VertxConsulConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxTrustOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setTrustStoreOptions((JksOptions)storeOptions);
                }
            } else if (trustAll) {
                VertxConsulConfigGateway.skipVerify(webClientOptions);
            } else if (agentConfig.keyStore().isPresent()) {
                Path trustStorePath = agentConfig.keyStore().get();
                String type = VertxConsulConfigGateway.determineStoreType(trustStorePath);
                KeyStoreOptionsBase storeOptions = VertxConsulConfigGateway.storeOptions(trustStorePath, agentConfig.keyStorePassword(), VertxConsulConfigGateway.createStoreOptions(type));
                if (VertxConsulConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxTrustOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setTrustStoreOptions((JksOptions)storeOptions);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions);
    }

    private static void skipVerify(WebClientOptions options) {
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }

    private static KeyStoreOptionsBase createStoreOptions(String type) {
        if (VertxConsulConfigGateway.isPfx(type)) {
            return new PfxOptions();
        }
        return new JksOptions();
    }

    private static boolean isPfx(String type) {
        return PKS_12.equals(type);
    }

    private static <T extends KeyStoreOptionsBase> KeyStoreOptionsBase storeOptions(Path storePath, Optional<String> storePassword, T store) throws Exception {
        return store.setPassword(storePassword.orElse("")).setValue(Buffer.buffer((byte[])VertxConsulConfigGateway.storeBytes(storePath)));
    }

    private static String determineStoreType(Path keyStorePath) {
        String pathName = keyStorePath.toString().toLowerCase();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return PKS_12;
        }
        return JKS;
    }

    private static byte[] storeBytes(Path keyStorePath) throws Exception {
        InputStream classPathResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStorePath.toString());
        if (classPathResource != null) {
            try (InputStream is = classPathResource;){
                byte[] byArray = VertxConsulConfigGateway.allBytes(is);
                return byArray;
            }
        }
        try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
            byte[] byArray = VertxConsulConfigGateway.allBytes(is);
            return byArray;
        }
    }

    private static byte[] allBytes(InputStream inputStream) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    @Override
    public Uni<Response> getValue(String key) {
        HttpRequest request = this.webClient.get(this.consulConfig.agent().hostPort().getPort(), this.consulConfig.agent().hostPort().getHostString(), "/v1/kv/" + key).ssl(Boolean.valueOf(this.consulConfig.agent().useHttps())).putHeader("Accept", "application/json;charset=UTF-8");
        if (this.consulConfig.agent().token().isPresent()) {
            request.putHeader("Authorization", "Bearer " + this.consulConfig.agent().token().get());
        }
        log.debug((Object)("Attempting to look up value of key '" + key + "' from Consul."));
        return request.send().map(r -> {
            if (r.statusCode() != 200) {
                log.debug((Object)("Look up of key '" + key + "' from Consul yielded a non success HTTP error-code: " + r.statusCode()));
                return null;
            }
            JsonArray jsonArray = r.bodyAsJsonArray();
            if (jsonArray.size() != 1) {
                throw new IllegalStateException("Consul returned an unexpected number of results when looking up value of key '" + key + "'");
            }
            JsonObject jsonObject = jsonArray.getJsonObject(0);
            return new Response(jsonObject.getString("Key"), jsonObject.getString("Value"));
        });
    }

    @Override
    public void close() {
        this.webClient.close();
        this.vertx.closeAndAwait();
    }
}

