/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.hocon.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.config.hocon.runtime.HoconConfigBuilder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.smallrye.config.SmallRyeConfig;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ConfigHoconProcessor {
    private static final String FEATURE = "hocon-config";

    @BuildStep
    public void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE));
    }

    @BuildStep
    public void hoconConfig(BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        staticInitConfigBuilder.produce((BuildItem)new StaticInitConfigBuilderBuildItem(HoconConfigBuilder.class.getName()));
        runTimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(HoconConfigBuilder.class.getName()));
    }

    @BuildStep
    void watchHoconConfig(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.conf");
        configWatchedFiles.add("application.conf");
        configWatchedFiles.add(Paths.get(userDir, "config", "application.conf").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.conf").toAbsolutePath().toString());
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        for (String profile : config.getProfiles()) {
            configWatchedFiles.add(String.format("application-%s.conf", profile));
            configWatchedFiles.add(String.format("application-%s.conf", profile));
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.conf", profile)).toAbsolutePath().toString());
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.conf", profile)).toAbsolutePath().toString());
        }
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }
}

