/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.hocon.runtime;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.source.hocon.HoconConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ApplicationHoconConfigSourceLoader
extends AbstractLocationConfigSourceLoader {
    protected String[] getFileExtensions() {
        return new String[]{"conf"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new HoconConfigSource(url, ordinal);
    }

    public static class InFileSystem
    extends ApplicationHoconConfigSourceLoader
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return new ArrayList<ConfigSource>(this.loadConfigSources(Paths.get(System.getProperty("user.dir"), "config", "application.conf").toUri().toString(), 265, classLoader));
        }

        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            return new ArrayList<ConfigSource>();
        }
    }

    public static class InClassPath
    extends ApplicationHoconConfigSourceLoader
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return new ArrayList<ConfigSource>(this.loadConfigSources("application.conf", 255, classLoader));
        }

        protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
            return new ArrayList<ConfigSource>();
        }
    }
}

