/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.jasypt.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import io.quarkus.config.jasypt.runtime.SecureRandomAccessor;
import java.security.SecureRandom;
import java.text.Normalizer;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.normalization.Normalizer;
import org.jasypt.salt.RandomSaltGenerator;

public class JasyptSubstitutions {

    @TargetClass(value=RandomIvGenerator.class)
    static final class Target_RandomIvGenerator {
        @Alias
        @InjectAccessors(value=SecureRandomAccessor.class)
        private SecureRandom random;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        String secureRandomAlgorithm;

        @Substitute
        @TargetElement(name="<init>")
        public Target_RandomIvGenerator(String secureRandomAlgorithm) {
            this.secureRandomAlgorithm = secureRandomAlgorithm;
        }
    }

    @TargetClass(value=RandomSaltGenerator.class)
    static final class Target_RandomSaltGenerator {
        @Alias
        @InjectAccessors(value=SecureRandomAccessor.class)
        private SecureRandom random;
        @Inject
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        String secureRandomAlgorithm;

        @Substitute
        @TargetElement(name="<init>")
        public Target_RandomSaltGenerator(String secureRandomAlgorithm) {
            this.secureRandomAlgorithm = secureRandomAlgorithm;
        }
    }

    @TargetClass(value=Normalizer.class)
    static final class Target_Normalizer {
        Target_Normalizer() {
        }

        @Substitute
        public static char[] normalizeToNfc(char[] message) {
            String result;
            String messageStr = new String(message);
            try {
                result = java.text.Normalizer.normalize(messageStr, Normalizer.Form.NFC);
            }
            catch (Exception e) {
                throw new EncryptionInitializationException("Could not perform a valid UNICODE normalization", (Throwable)e);
            }
            return result.toCharArray();
        }
    }
}

