/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.jasypt.runtime;

import io.quarkus.config.jasypt.runtime.JasyptSubstitutions;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jasypt.exceptions.EncryptionInitializationException;

class SecureRandomAccessor {
    private static volatile SecureRandom RANDOM;

    SecureRandomAccessor() {
    }

    static SecureRandom get(Object instance) {
        SecureRandom result = RANDOM;
        if (result == null) {
            result = SecureRandomAccessor.initializeOnce(SecureRandomAccessor.getAlgorithm(instance));
        }
        return result;
    }

    static void set(Object instance, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    private static synchronized SecureRandom initializeOnce(String algorithm) {
        SecureRandom result = RANDOM;
        if (result != null) {
            return result;
        }
        try {
            RANDOM = result = SecureRandom.getInstance(algorithm);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionInitializationException((Throwable)e);
        }
    }

    private static String getAlgorithm(Object instance) {
        if (instance instanceof JasyptSubstitutions.Target_RandomIvGenerator) {
            return ((JasyptSubstitutions.Target_RandomIvGenerator)instance).secureRandomAlgorithm;
        }
        if (instance instanceof JasyptSubstitutions.Target_RandomSaltGenerator) {
            return ((JasyptSubstitutions.Target_RandomSaltGenerator)instance).secureRandomAlgorithm;
        }
        return "SHA1PRNG";
    }
}

