/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.config.jdbc.runtime;

import io.quarkiverse.config.jdbc.runtime.JdbcConfigConfig;
import io.quarkiverse.config.jdbc.runtime.JdbcConfigSource;
import io.quarkiverse.config.jdbc.runtime.Repository;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.common.MapBackedConfigSource;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class JdbcConfigSourceFactory
implements ConfigSourceFactory.ConfigurableConfigSourceFactory<JdbcConfigConfig> {
    private static final Logger log = Logger.getLogger(JdbcConfigSourceFactory.class);

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, JdbcConfigConfig config) {
        if (!config.enabled()) {
            return Collections.emptyList();
        }
        try {
            Repository repository = new Repository(config);
            if (config.cache()) {
                return Collections.singletonList(new InMemoryConfigSource("jdbc-config", repository.getAllConfigValues(), 400));
            }
            return Collections.singletonList(new JdbcConfigSource("jdbc-config", repository, 400));
        }
        catch (SQLException e) {
            log.warn((Object)("jdbc-config disabled. reason: " + e.getLocalizedMessage()));
            return Collections.emptyList();
        }
    }

    private static final class InMemoryConfigSource
    extends MapBackedConfigSource {
        public InMemoryConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
            super(name, propertyMap, defaultOrdinal);
        }
    }
}

