/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cucumber.deployment;

import io.cucumber.java.StepDefinitionAnnotation;
import io.cucumber.java.StepDefinitionAnnotations;
import io.quarkiverse.cucumber.CucumberQuarkusTest;
import io.quarkiverse.cucumber.ScenarioContext;
import io.quarkiverse.cucumber.ScenarioScope;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class CucumberProcessor {
    private static final String FEATURE = "cucumber";

    CucumberProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexCucumber() {
        return new IndexDependencyBuildItem("io.cucumber", "cucumber-java");
    }

    @BuildStep
    AdditionalBeanBuildItem beanDefiningAnnotation(CombinedIndexBuildItem indexBuildItem) {
        HashSet<String> stepClasses = new HashSet<String>();
        for (DotName an : Arrays.asList(DotName.createSimple((String)StepDefinitionAnnotation.class.getName()), DotName.createSimple((String)StepDefinitionAnnotations.class.getName()))) {
            for (AnnotationInstance annotationInst : indexBuildItem.getIndex().getAnnotations(an)) {
                for (AnnotationInstance stepAnn : indexBuildItem.getIndex().getAnnotations(annotationInst.target().asClass().name())) {
                    stepClasses.add(stepAnn.target().asMethod().declaringClass().name().toString());
                }
            }
        }
        for (ClassInfo i : indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)CucumberQuarkusTest.class.getName()))) {
            stepClasses.add(i.name().toString());
        }
        return AdditionalBeanBuildItem.builder().addBeanClasses(stepClasses).setDefaultScope(DotName.createSimple((String)ScenarioScope.class.getName())).setUnremovable().build();
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem scenarioContext(ContextRegistrationPhaseBuildItem contextRegistrationPhase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{contextRegistrationPhase.getContext().configure(ScenarioScope.class).normal().contextClass(ScenarioContext.class)});
    }

    @BuildStep
    CustomScopeBuildItem scenarioScope() {
        return new CustomScopeBuildItem(DotName.createSimple((String)ScenarioScope.class.getName()));
    }
}

