/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cucumber;

import io.quarkiverse.cucumber.ScenarioScope;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class ScenarioContext
implements InjectableContext {
    private final ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> instances = new ConcurrentHashMap();
    private final Lock beanLock = new ReentrantLock();

    public void destroy() {
        for (ContextInstanceHandle contextInstanceHandle : this.instances.values()) {
            contextInstanceHandle.destroy();
        }
        this.instances.clear();
    }

    public void destroy(Contextual<?> contextual) {
        try (ContextInstanceHandle contextInstanceHandle = (ContextInstanceHandle)this.instances.remove(contextual);){
            if (contextInstanceHandle != null) {
                contextInstanceHandle.destroy();
            }
        }
    }

    public Class<? extends Annotation> getScope() {
        return ScenarioScope.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        ContextInstanceHandle contextInstanceHandle = (ContextInstanceHandle)this.instances.get(contextual);
        if (contextInstanceHandle != null) {
            return (T)contextInstanceHandle.get();
        }
        if (creationalContext != null) {
            this.beanLock.lock();
            try {
                Object createdInstance = contextual.create(creationalContext);
                this.instances.put(contextual, (ContextInstanceHandle<?>)new ContextInstanceHandleImpl((InjectableBean)contextual, createdInstance, creationalContext));
                Object object = createdInstance;
                return (T)object;
            }
            finally {
                this.beanLock.unlock();
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return true;
    }

    public InjectableContext.ContextState getState() {
        return new ScenarioContextState(this.instances);
    }

    private record ScenarioContextState(Map<Contextual<?>, ContextInstanceHandle<?>> instances) implements InjectableContext.ContextState
    {
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.instances.values().stream().collect(Collectors.toMap(InstanceHandle::getBean, InstanceHandle::get));
        }
    }
}

