/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment.codegen;

import io.quarkiverse.cxf.deployment.CxfBuildTimeConfig;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.util.GlobUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class Wsdl2JavaCodeGen
implements CodeGenProvider {
    private static final Logger log = Logger.getLogger(Wsdl2JavaCodeGen.class);
    public static final String WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX = "quarkus.cxf.codegen.wsdl2java.";
    public static final String WSDL2JAVA_CONFIG_KEY_PREFIX = "quarkus.cxf.codegen.wsdl2java";
    private static final Path SRC_MAIN_RESOURCES = Paths.get("src/main/resources", new String[0]);
    private static final Path SRC_TEST_RESOURCES = Paths.get("src/test/resources", new String[0]);

    public String providerId() {
        return "wsdl2java";
    }

    public String inputExtension() {
        return "wsdl";
    }

    public String inputDirectory() {
        return "resources";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Config config = context.config();
        if (!config.getOptionalValue("quarkus.cxf.codegen.wsdl2java.enabled", Boolean.class).orElse(true).booleanValue()) {
            log.info((Object)("Skipping " + this.getClass() + " invocation on user's request"));
            return false;
        }
        Path outDir = context.outDir();
        Function<String, Optional<List<String>>> configFunction = key -> config.getOptionalValues(key, String.class);
        CxfBuildTimeConfig.Wsdl2JavaParameterSet rootParams = Wsdl2JavaCodeGen.buildParameterSet(configFunction, WSDL2JAVA_CONFIG_KEY_PREFIX);
        HashMap<String, String> processedFiles = new HashMap<String, String>();
        boolean result = false;
        result |= Wsdl2JavaCodeGen.wsdl2java(context.inputDir(), rootParams, outDir, WSDL2JAVA_CONFIG_KEY_PREFIX, processedFiles);
        Set<String> names = Wsdl2JavaCodeGen.findParamSetNames(config.getPropertyNames());
        for (String name : names) {
            String prefix = WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX + name;
            CxfBuildTimeConfig.Wsdl2JavaParameterSet namedParams = Wsdl2JavaCodeGen.buildParameterSet(configFunction, prefix);
            result |= Wsdl2JavaCodeGen.wsdl2java(context.inputDir(), namedParams, outDir, prefix, processedFiles);
        }
        if (!result) {
            log.infof("wsdl2java processed 0 WSDL files under %s", (Object)Wsdl2JavaCodeGen.absModuleRoot(context.inputDir()).relativize(context.inputDir()));
        }
        return result;
    }

    static boolean wsdl2java(Path inputDir, CxfBuildTimeConfig.Wsdl2JavaParameterSet params, Path outDir, String prefix, Map<String, String> processedFiles) {
        return Wsdl2JavaCodeGen.scan(inputDir, params.includes, params.excludes, prefix, processedFiles, wsdlFile -> {
            Wsdl2JavaParams wsdl2JavaParams = new Wsdl2JavaParams(inputDir, outDir, (Path)wsdlFile, params.additionalParams.orElse(Collections.emptyList()));
            if (log.isInfoEnabled()) {
                log.info((Object)wsdl2JavaParams.appendLog(new StringBuilder("Running wsdl2java")).toString());
            }
            ToolContext ctx = new ToolContext();
            try {
                new WSDLToJava(wsdl2JavaParams.toParameterArray()).run(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(wsdl2JavaParams.appendLog(new StringBuilder("Could not run wsdl2Java")).toString(), e);
            }
        });
    }

    public static boolean scan(Path inputDir, Optional<List<String>> includes, Optional<List<String>> excludes, String prefix, Map<String, String> processedFiles, Consumer<Path> wsdlFileConsumer) {
        if (includes.isEmpty()) {
            return false;
        }
        String selectors = "    " + prefix + ".includes = " + includes.get().stream().collect(Collectors.joining(",")) + (String)(excludes.isPresent() ? "\n    " + prefix + ".excludes = " + excludes.get().stream().collect(Collectors.joining(",")) : "");
        Consumer<Path> chainedConsumer = wsdlFile -> {
            String oldSelectors = (String)processedFiles.get(wsdlFile.toString());
            if (oldSelectors != null) {
                throw new IllegalStateException("WSDL file " + wsdlFile + " was already selected by\n\n" + oldSelectors + "\n\nand therefore it cannot once again be selected by\n\n" + selectors + "\n\nPlease make sure that the individual include/exclude sets are mutually exclusive.");
            }
            processedFiles.put(wsdlFile.toString(), selectors);
            wsdlFileConsumer.accept((Path)wsdlFile);
        };
        List<Pattern> excludePatterns = excludes.orElse(Collections.emptyList()).stream().map(GlobUtil::toRegexPattern).map(Pattern::compile).collect(Collectors.toList());
        AtomicBoolean result = new AtomicBoolean(false);
        for (String include : includes.get()) {
            String[] parts = Wsdl2JavaCodeGen.splitGlob(include);
            if (parts.length == 1) {
                Stream.of(include).filter(relPath -> excludePatterns.stream().noneMatch(exclPattern -> exclPattern.matcher((CharSequence)relPath).matches())).map(inputDir::resolve).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(path -> result.set(true)).forEach(chainedConsumer);
                continue;
            }
            if (parts.length == 2) {
                if (parts[0].length() == 0) {
                    if (!Wsdl2JavaCodeGen.walk(inputDir, inputDir, parts[1], excludePatterns, chainedConsumer)) continue;
                    result.set(true);
                    continue;
                }
                if (!Wsdl2JavaCodeGen.walk(inputDir, inputDir.resolve(parts[0]), parts[1], excludePatterns, chainedConsumer)) continue;
                result.set(true);
                continue;
            }
            throw new IllegalStateException("Expected glob split array length 1 or 2, found " + parts.length);
        }
        return result.get();
    }

    static boolean walk(Path workDir, Path directory, String includeGlob, List<Pattern> excludePatterns, Consumer<Path> wsdlFileConsumer) {
        Pattern includePattern = Pattern.compile(GlobUtil.toRegexPattern((String)includeGlob));
        AtomicBoolean result = new AtomicBoolean(false);
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
                stream.map(directory::resolve).filter(absPath -> {
                    String relPathWorkDir;
                    String relPathDir;
                    if (File.separatorChar != '/') {
                        relPathDir = directory.relativize((Path)absPath).toString().replace(File.separatorChar, '/');
                        relPathWorkDir = workDir.relativize((Path)absPath).toString().replace(File.separatorChar, '/');
                    } else {
                        relPathDir = directory.relativize((Path)absPath).toString();
                        relPathWorkDir = workDir.relativize((Path)absPath).toString();
                    }
                    return includePattern.matcher(relPathDir).matches() && excludePatterns.stream().noneMatch(exclPattern -> exclPattern.matcher(relPathWorkDir).matches());
                }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(path -> result.set(true)).forEach(wsdlFileConsumer);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not walk directory " + directory, e);
            }
        }
        return result.get();
    }

    static String[] splitGlob(String glob) {
        int lastSlashPos = Integer.MAX_VALUE;
        block5: for (int i = 0; i < glob.length(); ++i) {
            char ch = glob.charAt(i);
            switch (ch) {
                case '\\': {
                    ++i;
                    continue block5;
                }
                case '/': {
                    lastSlashPos = i;
                    continue block5;
                }
                case '*': 
                case '?': 
                case '[': 
                case '{': {
                    if (i > lastSlashPos) {
                        return new String[]{glob.substring(0, lastSlashPos), glob.substring(lastSlashPos + 1)};
                    }
                    return new String[]{"", glob};
                }
            }
        }
        return new String[]{glob};
    }

    static Set<String> findParamSetNames(Iterable<String> propertyNames) {
        TreeSet<String> result = new TreeSet<String>();
        for (String key : propertyNames) {
            if (!key.startsWith(WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX)) continue;
            Stream.of(".includes", ".excludes", ".additional-params").filter(suffix -> key.endsWith((String)suffix)).findFirst().ifPresent(suffix -> {
                if (WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX.length() + suffix.length() < key.length()) {
                    String name = key.substring(WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX.length(), key.length() - suffix.length());
                    result.add(name);
                }
            });
        }
        return result;
    }

    static CxfBuildTimeConfig.Wsdl2JavaParameterSet buildParameterSet(Function<String, Optional<List<String>>> config, String prefix) {
        CxfBuildTimeConfig.Wsdl2JavaParameterSet result = new CxfBuildTimeConfig.Wsdl2JavaParameterSet();
        Optional<List<String>> maybeIncludes = config.apply(prefix + ".includes");
        List<String> includes = maybeIncludes.isPresent() ? maybeIncludes.get() : null;
        Optional<List<String>> excludes = config.apply(prefix + ".excludes");
        Optional<List<String>> additionalParams = config.apply(prefix + ".additional-params");
        if (includes == null && (excludes.isPresent() || additionalParams.isPresent())) {
            throw new IllegalStateException("Incomplete configuration: you must set " + prefix + ".includes if you set any of " + prefix + ".excludes or " + prefix + ".additional-params");
        }
        result.includes = Optional.ofNullable(includes);
        result.excludes = excludes;
        result.additionalParams = additionalParams;
        return result;
    }

    static Path absModuleRoot(Path inputDir) {
        if (inputDir.endsWith(SRC_MAIN_RESOURCES) || inputDir.endsWith(SRC_TEST_RESOURCES)) {
            return inputDir.getParent().getParent().getParent();
        }
        throw new IllegalStateException("inputDir '" + inputDir + "' expected to end with " + SRC_MAIN_RESOURCES + " or " + SRC_TEST_RESOURCES);
    }

    static class Wsdl2JavaParams {
        private final Path inputDir;
        private final Path outDir;
        private final Path wsdlFile;
        private final List<String> additionalParams;

        public Wsdl2JavaParams(Path inputDir, Path outDir, Path wsdlFile, List<String> additionalParams) {
            this.inputDir = inputDir;
            this.outDir = outDir;
            this.wsdlFile = wsdlFile;
            this.additionalParams = additionalParams;
        }

        public StringBuilder appendLog(StringBuilder sb) {
            Path moduleRoot = Wsdl2JavaCodeGen.absModuleRoot(this.inputDir);
            this.render(path -> moduleRoot.relativize((Path)path).toString(), value -> sb.append(' ').append((String)value));
            return sb;
        }

        public String[] toParameterArray() {
            String[] result = new String[this.additionalParams.size() + 3];
            AtomicInteger i = new AtomicInteger(0);
            this.render(Path::toString, value -> {
                result[i.getAndIncrement()] = value;
            });
            return result;
        }

        void render(Function<Path, String> pathTransformer, Consumer<String> paramConsumer) {
            paramConsumer.accept("-d");
            paramConsumer.accept(pathTransformer.apply(this.outDir));
            this.additionalParams.forEach(paramConsumer);
            paramConsumer.accept(pathTransformer.apply(this.wsdlFile));
        }
    }
}

