/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CxfClientProducer;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.annotation.CXFClient;
import io.quarkiverse.cxf.deployment.CxfBusBuildItem;
import io.quarkiverse.cxf.deployment.CxfClientBuildItem;
import io.quarkiverse.cxf.deployment.CxfDeploymentUtils;
import io.quarkiverse.cxf.deployment.CxfDotNames;
import io.quarkiverse.cxf.deployment.CxfWrapperClassNamesBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.ReflectiveBeanClassBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class CxfClientProcessor {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProcessor.class);

    @BuildStep
    void collectClients(CombinedIndexBuildItem combinedIndexBuildItem, CxfBusBuildItem bus, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveBeanClassBuildItem> reflectiveBeanClass, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies, BuildProducer<CxfClientBuildItem> clients, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Set<String> clientSEIsInUse = CxfClientProcessor.findClientSEIsInUse(index);
        CxfDeploymentUtils.webServiceAnnotations(index).forEach(annotation -> {
            ClassInfo wsClassInfo = annotation.target().asClass();
            if (clientSEIsInUse.contains(wsClassInfo.name().toString())) {
                String wsNamespace;
                String wsName;
                String sei = wsClassInfo.name().toString();
                AnnotationInstance webserviceClient = CxfClientProcessor.findWebServiceClientAnnotation(index, wsClassInfo.name());
                if (webserviceClient != null) {
                    wsName = webserviceClient.value("name").asString();
                    wsNamespace = webserviceClient.value("targetNamespace").asString();
                } else {
                    wsName = Optional.ofNullable(annotation.value("serviceName")).map(AnnotationValue::asString).orElse("");
                    wsNamespace = Optional.ofNullable(annotation.value("targetNamespace")).map(AnnotationValue::asString).orElseGet(() -> CxfDeploymentUtils.getNameSpaceFromClassInfo(wsClassInfo));
                }
                String soapBinding = Optional.ofNullable(wsClassInfo.classAnnotation(CxfDotNames.BINDING_TYPE_ANNOTATION)).map(bindingType -> bindingType.value().asString()).orElse("http://schemas.xmlsoap.org/wsdl/soap/http");
                clients.produce((BuildItem)new CxfClientBuildItem(sei, soapBinding, wsNamespace, wsName));
                proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{wsClassInfo.name().toString(), "javax.xml.ws.BindingProvider", "java.io.Closeable", "org.apache.cxf.endpoint.Client"}));
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startClient(CXFRecorder recorder, CxfConfig cxfConfig, List<CxfClientBuildItem> clients, CxfWrapperClassNamesBuildItem cxfWrapperClassNames, BuildProducer<SyntheticBeanBuildItem> synthetics) {
        Map<String, List<String>> wrapperClassNames = cxfWrapperClassNames.getWrapperClassNames();
        clients.stream().map(client -> new CXFClientData(client.getSoapBinding(), client.getSei(), client.getWsName(), client.getWsNamespace(), (List)wrapperClassNames.get(client.getSei()))).map(cxf -> {
            LOGGER.debugf("producing dedicated CXFClientInfo bean named '%s' for SEI %s", (Object)cxf.getSei(), (Object)cxf.getSei());
            return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CXFClientInfo.class).named(cxf.getSei())).runtimeValue(recorder.cxfClientInfoSupplier(cxf)).unremovable()).setRuntimeInit().done();
        }).forEach(arg_0 -> synthetics.produce(arg_0));
    }

    private static AnnotationInstance findWebServiceClientAnnotation(IndexView index, DotName seiName) {
        Collection annotations = index.getAnnotations(CxfDotNames.WEBSERVICE_CLIENT);
        for (AnnotationInstance annotation : annotations) {
            ClassInfo targetClass = annotation.target().asClass();
            for (MethodInfo method : targetClass.methods()) {
                if (!method.returnType().name().equals((Object)seiName)) continue;
                return annotation;
            }
        }
        return null;
    }

    private static Set<String> findClientSEIsInUse(IndexView index) {
        return index.getAnnotations(CxfDotNames.CXFCLIENT_ANNOTATION).stream().map(AnnotationInstance::target).map(target -> {
            switch (target.kind()) {
                case FIELD: {
                    return target.asField().type();
                }
                case METHOD_PARAMETER: {
                    MethodParameterInfo paramInfo = target.asMethodParameter();
                    return (Type)paramInfo.method().parameterTypes().get(paramInfo.position());
                }
            }
            return null;
        }).filter(Objects::nonNull).map(type -> type.name().equals((Object)CxfDotNames.INJECT_INSTANCE) ? (Type)type.asParameterizedType().arguments().get(0) : type).map(type -> type.name().toString()).collect(Collectors.toSet());
    }

    @BuildStep
    void generateClientProducers(List<CxfClientBuildItem> clients, CxfWrapperClassNamesBuildItem cxfWrapperClassNames, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        clients.stream().map(CxfClientBuildItem::getSei).forEach(sei -> this.generateCxfClientProducer((String)sei, generatedBeans, unremovableBeans));
    }

    private void generateCxfClientProducer(String sei, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        String cxfClientProducerClassName = sei + "CxfClientProducer";
        GeneratedBeanGizmoAdaptor classoutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classoutput).className(cxfClientProducerClassName).superClass(CxfClientProducer.class).build();){
            classCreator.addAnnotation(ApplicationScoped.class);
            FieldCreator info = (FieldCreator)classCreator.getFieldCreator("info", "io.quarkiverse.cxf.CXFClientInfo").setModifiers(1);
            info.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)sei)}));
            info.addAnnotation(AnnotationInstance.create((DotName)DotName.createSimple((String)Inject.class.getName()), null, (AnnotationValue[])new AnnotationValue[0]));
            try (MethodCreator createService = classCreator.getMethodCreator("createService", (Object)sei, new Object[]{InjectionPoint.class});){
                createService.addAnnotation(Produces.class);
                createService.addAnnotation(CXFClient.class);
                ResultHandle thisHandle = createService.getThis();
                ResultHandle injectionPointHandle = createService.getMethodParam(0);
                ResultHandle cxfClientInfoHandle = createService.readInstanceField(info.getFieldDescriptor(), thisHandle);
                MethodDescriptor loadCxfClient = MethodDescriptor.ofMethod(CxfClientProducer.class, (String)"loadCxfClient", (Object)"java.lang.Object", (Object[])new Object[]{InjectionPoint.class, CXFClientInfo.class});
                ResultHandle cxfClient = createService.invokeVirtualMethod(loadCxfClient, thisHandle, new ResultHandle[]{injectionPointHandle, cxfClientInfoHandle});
                createService.returnValue(createService.checkCast(cxfClient, sei));
            }
        }
        this.produceUnremovableBean(unremovableBeans, cxfClientProducerClassName);
    }

    private void produceUnremovableBean(BuildProducer<UnremovableBeanBuildItem> unremovables, String ... args) {
        Arrays.stream(args).map(UnremovableBeanBuildItem.BeanClassNameExclusion::new).map(UnremovableBeanBuildItem::new).forEach(arg_0 -> unremovables.produce(arg_0));
    }
}

