/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment.devconsole;

import io.quarkiverse.cxf.deployment.CxfClientBuildItem;
import io.quarkiverse.cxf.deployment.CxfEndpointImplementationBuildItem;
import io.quarkiverse.cxf.devconsole.DevCxfClientInfosSupplier;
import io.quarkiverse.cxf.devconsole.DevCxfServerInfosSupplier;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import java.util.List;
import java.util.function.Supplier;

public class DevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectBeanInfo(List<CxfEndpointImplementationBuildItem> webservices, List<CxfClientBuildItem> clients, BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplates) {
        devConsoleTemplates.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("cxfClientBuildItems", clients));
        devConsoleTemplates.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("cxfEndpointImplementationBuildItems", webservices));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem collectClientBeanInfo(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("cxfClientInfos", (Supplier)new DevCxfClientInfosSupplier(), DevConsoleProcessor.class, curateOutcomeBuildItem);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem collectServerBeanInfo(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("cxfServiceInfos", (Supplier)new DevCxfServerInfosSupplier(), DevConsoleProcessor.class, curateOutcomeBuildItem);
    }
}

