/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class NeethiProcessor {
    private static final Set<String> BANNED_CONVERTERS = Set.of("org.apache.neethi.builders.converters.StaxToOMConverter", "org.apache.neethi.builders.converters.OMToStaxConverter", "org.apache.neethi.builders.converters.OMToDOMConverter", "org.apache.neethi.builders.converters.DOMToOMConverter", "org.apache.neethi.builders.converters.OMToOMConverter");

    NeethiProcessor() {
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencies) {
        Stream.of("org.apache.neethi:neethi").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1]));
        });
    }

    @BuildStep
    void reflectiveClass(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndexBuildItem.getIndex();
        index.getAllKnownImplementors(DotName.createSimple((String)"org.apache.neethi.builders.converters.Converter")).stream().map(classInfo -> classInfo.name().toString()).filter(cl -> !BANNED_CONVERTERS.contains(cl)).map(className -> new ReflectiveClassBuildItem(true, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        String abstractDomCoverter = "org.apache.neethi.builders.converters.AbstractDOMConverter";
        Stream.concat(Stream.of("org.apache.neethi.builders.converters.AbstractDOMConverter"), index.getAllKnownSubclasses(DotName.createSimple((String)"org.apache.neethi.builders.converters.AbstractDOMConverter")).stream().map(classInfo -> classInfo.name().toString())).filter(cl -> !BANNED_CONVERTERS.contains(cl)).map(className -> new ReflectiveClassBuildItem(true, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
    }
}

