/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment.codegen;

import io.quarkiverse.cxf.deployment.CxfBuildTimeConfig;
import io.quarkiverse.cxf.deployment.codegen.Wsdl2JavaParam;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.PathFilter;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.WithDefault;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.jboss.logging.Logger;

public class Wsdl2JavaCodeGen
implements CodeGenProvider {
    private static final Logger log = Logger.getLogger(Wsdl2JavaCodeGen.class);
    public static final String WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX = "quarkus.cxf.codegen.wsdl2java.";
    public static final String WSDL2JAVA_CONFIG_KEY_PREFIX = "quarkus.cxf.codegen.wsdl2java";
    private static final Path SRC_MAIN_RESOURCES = Paths.get("src/main/resources", new String[0]);
    private static final Path SRC_TEST_RESOURCES = Paths.get("src/test/resources", new String[0]);

    public String providerId() {
        return "wsdl2java";
    }

    public String inputExtension() {
        return "wsdl";
    }

    public String inputDirectory() {
        return "resources";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        try {
            BuildTimeConfigurationReader reader = new BuildTimeConfigurationReader(Thread.currentThread().getContextClassLoader());
            BuildTimeConfigurationReader.ReadResult readResult = reader.readConfiguration((SmallRyeConfig)context.config());
            CxfBuildTimeConfig.Wsdl2JavaConfig config = ((CxfBuildTimeConfig)readResult.requireObjectForClass(CxfBuildTimeConfig.class)).codegen().wsdl2java();
            if (!config.enabled()) {
                log.info((Object)("Skipping " + this.getClass() + " invocation on user's request"));
                return false;
            }
            Path outDir = context.outDir();
            CxfBuildTimeConfig.Wsdl2JavaParameterSet rootParams = config.rootParameterSet();
            HashMap<String, String> processedFiles = new HashMap<String, String>();
            boolean result = false;
            Path projectDir = context.workDir().getParent();
            result |= Wsdl2JavaCodeGen.wsdl2java(projectDir, context.inputDir(), rootParams, outDir, WSDL2JAVA_CONFIG_KEY_PREFIX, processedFiles);
            for (Map.Entry<String, CxfBuildTimeConfig.Wsdl2JavaParameterSet> en : config.namedParameterSets().entrySet()) {
                String prefix = WSDL2JAVA_NAMED_CONFIG_KEY_PREFIX + en.getKey();
                CxfBuildTimeConfig.Wsdl2JavaParameterSet namedParams = en.getValue();
                result |= Wsdl2JavaCodeGen.wsdl2java(projectDir, context.inputDir(), namedParams, outDir, prefix, processedFiles);
            }
            if (!result) {
                log.infof("wsdl2java processed 0 WSDL files under %s", (Object)Wsdl2JavaCodeGen.absModuleRoot(context.inputDir()).relativize(context.inputDir()));
            }
            return result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean wsdl2java(Path projectDir, Path inputDir, CxfBuildTimeConfig.Wsdl2JavaParameterSet params, Path outDir, String prefix, Map<String, String> processedFiles) {
        return Wsdl2JavaCodeGen.scan(inputDir, params.includes(), params.excludes(), prefix, processedFiles, wsdlFile -> {
            Wsdl2JavaParams wsdl2JavaParams = new Wsdl2JavaParams(projectDir, inputDir, outDir, (Path)wsdlFile, params);
            if (log.isInfoEnabled()) {
                log.info((Object)wsdl2JavaParams.appendLog(new StringBuilder("Running wsdl2java")).toString());
            }
            ToolContext ctx = new ToolContext();
            try {
                new WSDLToJava(wsdl2JavaParams.toParameterArray()).run(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(wsdl2JavaParams.appendLog(new StringBuilder("Could not run wsdl2Java")).toString(), e);
            }
        });
    }

    public static boolean scan(Path inputDir, Optional<List<String>> includes, Optional<List<String>> excludes, String prefix, Map<String, String> processedFiles, Consumer<Path> wsdlFileConsumer) {
        if (includes.isEmpty()) {
            return false;
        }
        String selectors = "    " + prefix + ".includes = " + includes.get().stream().collect(Collectors.joining(",")) + (String)(excludes.isPresent() ? "\n    " + prefix + ".excludes = " + excludes.get().stream().collect(Collectors.joining(",")) : "");
        Consumer<Path> chainedConsumer = wsdlFile -> {
            String oldSelectors = (String)processedFiles.get(wsdlFile.toString());
            if (oldSelectors != null) {
                throw new IllegalStateException("WSDL file " + wsdlFile + " was already selected by\n\n" + oldSelectors + "\n\nand therefore it cannot once again be selected by\n\n" + selectors + "\n\nPlease make sure that the individual include/exclude sets are mutually exclusive.");
            }
            processedFiles.put(wsdlFile.toString(), selectors);
            wsdlFileConsumer.accept((Path)wsdlFile);
        };
        try (DirectoryPathTree pathTree = new DirectoryPathTree(inputDir, new PathFilter((Collection)includes.orElse(null), (Collection)excludes.orElse(null)));){
            pathTree.walk(pathVisit -> {
                Path path = pathVisit.getPath();
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    chainedConsumer.accept(path);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not walk directory " + inputDir, e);
        }
        return !processedFiles.isEmpty();
    }

    static Path absModuleRoot(Path inputDir) {
        if (inputDir.endsWith(SRC_MAIN_RESOURCES) || inputDir.endsWith(SRC_TEST_RESOURCES)) {
            return inputDir.getParent().getParent().getParent();
        }
        throw new IllegalStateException("inputDir '" + inputDir + "' expected to end with " + SRC_MAIN_RESOURCES + " or " + SRC_TEST_RESOURCES);
    }

    static class Wsdl2JavaParams {
        private final Path projectDir;
        private final Path inputDir;
        private final Path outDir;
        private final Path wsdlFile;
        private final CxfBuildTimeConfig.Wsdl2JavaParameterSet params;

        public Wsdl2JavaParams(Path projectDir, Path inputDir, Path outDir, Path wsdlFile, CxfBuildTimeConfig.Wsdl2JavaParameterSet params) {
            this.projectDir = projectDir;
            this.inputDir = inputDir;
            this.outDir = outDir;
            this.wsdlFile = wsdlFile;
            this.params = params;
        }

        static String absolutizeBindings(Path projectDir, String rawBindingFile) {
            Path bindingPath = Paths.get(rawBindingFile, new String[0]);
            if (!bindingPath.isAbsolute()) {
                return projectDir.resolve(bindingPath).toString();
            }
            return rawBindingFile;
        }

        static List<String> absolutizeBindings(Path projectDir, List<String> additionalParams) {
            ArrayList<String> result = new ArrayList<String>(additionalParams);
            ListIterator<String> it = result.listIterator();
            while (it.hasNext()) {
                String val = (String)it.next();
                if (!"-b".equals(val) || !it.hasNext()) continue;
                it.set(Wsdl2JavaParams.absolutizeBindings(projectDir, (String)it.next()));
            }
            return result;
        }

        public StringBuilder appendLog(StringBuilder sb) {
            this.render(Path::toString, value -> sb.append(' ').append((String)value));
            return sb;
        }

        public String[] toParameterArray() {
            ArrayList result = new ArrayList();
            this.render(Path::toString, result::add);
            return result.toArray(new String[0]);
        }

        void render(Function<Path, String> pathTransformer, Consumer<String> paramConsumer) {
            paramConsumer.accept("-d");
            paramConsumer.accept(pathTransformer.apply(this.outDir));
            Stream.of(CxfBuildTimeConfig.Wsdl2JavaParameterSet.class.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).forEach(method -> {
                Wsdl2JavaParam wsdl2JavaParam = method.getAnnotation(Wsdl2JavaParam.class);
                WithDefault withDefault = method.getAnnotation(WithDefault.class);
                if (wsdl2JavaParam != null) {
                    String paramName = wsdl2JavaParam.value();
                    try {
                        Object value = this.params.getClass().getDeclaredMethod(method.getName(), new Class[0]).invoke((Object)this.params, new Object[0]);
                        if (value instanceof Optional) {
                            if (((Optional)value).isPresent()) {
                                Object optValue = ((Optional)value).get();
                                if (optValue instanceof Collection) {
                                    Wsdl2JavaParams.renderCollection(paramName, (Collection)optValue, wsdl2JavaParam, paramConsumer, this.projectDir);
                                } else {
                                    Wsdl2JavaParams.renderSingle(paramName, optValue, wsdl2JavaParam, null, paramConsumer);
                                }
                            }
                        } else if (value instanceof Collection) {
                            Wsdl2JavaParams.renderCollection(paramName, (Collection)value, wsdl2JavaParam, paramConsumer, this.projectDir);
                        } else {
                            Wsdl2JavaParams.renderSingle(paramName, value, wsdl2JavaParam, withDefault, paramConsumer);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.params.additionalParams().ifPresent(vals -> Wsdl2JavaParams.absolutizeBindings(this.projectDir, vals).forEach(paramConsumer));
            paramConsumer.accept(pathTransformer.apply(this.wsdlFile));
        }

        static void renderSingle(String paramName, Object value, Wsdl2JavaParam wsdl2JavaParam, WithDefault withDefault, Consumer<String> paramConsumer) {
            switch (wsdl2JavaParam.transformer()) {
                case bool: {
                    System.out.println("bool " + value + " " + value.getClass().getName());
                    if (paramName == null || !Boolean.TRUE.equals(value)) break;
                    paramConsumer.accept(paramName);
                    break;
                }
                case toString: {
                    String stringValue = value.toString();
                    if (withDefault != null && stringValue.equals(withDefault.value())) break;
                    if (paramName != null) {
                        paramConsumer.accept(paramName);
                    }
                    paramConsumer.accept(stringValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + Wsdl2JavaParam.Wsdl2JavaParamTransformer.class.getName() + ": " + wsdl2JavaParam.transformer());
                }
            }
        }

        static void renderCollection(String paramName, Collection<?> collection, Wsdl2JavaParam wsdl2JavaParam, Consumer<String> paramConsumer, Path projectDir) {
            switch (wsdl2JavaParam.collection()) {
                case commaSeparated: {
                    paramConsumer.accept(paramName);
                    boolean first = true;
                    StringBuilder sb = new StringBuilder();
                    for (Object value : collection) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(',');
                        }
                        Wsdl2JavaParams.renderSingle(null, value, wsdl2JavaParam, null, sb::append);
                    }
                    paramConsumer.accept(sb.toString());
                    break;
                }
                case multiParam: {
                    for (Object value : collection) {
                        paramConsumer.accept(paramName);
                        if (paramName.equals("-b")) {
                            value = Wsdl2JavaParams.absolutizeBindings(projectDir, (String)value);
                        }
                        Wsdl2JavaParams.renderSingle(null, value, wsdl2JavaParam, null, paramConsumer);
                    }
                    break;
                }
                case xjc: {
                    for (Object value : collection) {
                        paramConsumer.accept(paramName + "-X" + value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + Wsdl2JavaParam.Wsdl2JavaParamCollection.class.getName() + ": " + wsdl2JavaParam.collection());
                }
            }
        }
    }
}

