/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.WebServiceContextProducer;
import io.quarkiverse.cxf.deployment.CxfDotNames;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class WebServiceContextProcessor {
    private static final Logger log = Logger.getLogger(WebServiceContextProcessor.class);
    private static final Type WEBSERVICE_CONTEXT_TYPE = Type.create((DotName)CxfDotNames.WEBSERVICE_CONTEXT, (Type.Kind)Type.Kind.CLASS);

    @BuildStep
    void webServiceContextProducer(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WebServiceContextProducer.class));
    }

    @BuildStep
    void addInjectForResource(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AnnotationsTransformerBuildItem> annotationTransformer) {
        IndexView index = combinedIndexBuildItem.getIndex();
        ClassLevelResourceAnnotations classLevelResourceAnnotations = new ClassLevelResourceAnnotations(index);
        index.getAnnotations(CxfDotNames.JAKARTA_ANNOTATION_RESOURCE).stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.CLASS).forEach(a -> classLevelResourceAnnotations.handleResource(a.target().asClass(), (AnnotationInstance)a));
        index.getAnnotations(CxfDotNames.JAKARTA_ANNOTATION_RESOURCES).stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.CLASS).forEach(a -> {
            List values;
            AnnotationValue value = a.value();
            if (value != null && (values = value.asArrayList()).size() > 0) {
                for (AnnotationValue res : values) {
                    classLevelResourceAnnotations.handleResource(a.target().asClass(), res.asNested());
                }
            }
        });
        annotationTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationTransformation.FieldBuilder)AnnotationTransformation.forFields().when(ctx -> {
            FieldInfo fld = ctx.declaration().asField();
            return WebServiceContextProcessor.isWebServiceContext(fld.type()) && !ctx.hasAnnotation(CxfDotNames.INJECT) && (ctx.hasAnnotation(CxfDotNames.JAKARTA_ANNOTATION_RESOURCE) || classLevelResourceAnnotations.containsField(fld.declaringClass().name(), fld.name()));
        })).transform(ctx -> {
            FieldInfo fld = ctx.declaration().asField();
            if (log.isDebugEnabled()) {
                log.debugf("Adding %s to %s.%s", (Object)Inject.class.getName(), (Object)fld.declaringClass().name(), (Object)fld.name());
            }
            ctx.add(AnnotationInstance.create((DotName)CxfDotNames.INJECT, (AnnotationTarget)fld, (AnnotationValue[])new AnnotationValue[0]));
        })));
        annotationTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationTransformation.MethodBuilder)AnnotationTransformation.forMethods().when(ctx -> {
            MethodInfo method = ctx.declaration().asMethod();
            return WebServiceContextProcessor.setsWebServiceContext(method) && !ctx.hasAnnotation(CxfDotNames.INJECT) && (ctx.hasAnnotation(CxfDotNames.JAKARTA_ANNOTATION_RESOURCE) || classLevelResourceAnnotations.containsSetter(method.declaringClass().name(), method.name()));
        })).transform(ctx -> {
            MethodInfo method = ctx.declaration().asMethod();
            if (log.isDebugEnabled()) {
                log.debugf("Adding %s to %s.%s(%s)", new Object[]{Inject.class.getName(), method.declaringClass().name(), method.name(), method.parameterType(0).name()});
            }
            ctx.add(AnnotationInstance.create((DotName)CxfDotNames.INJECT, (AnnotationTarget)method, (AnnotationValue[])new AnnotationValue[0]));
        })));
    }

    static boolean setsWebServiceContext(MethodInfo method) {
        return method.parametersCount() == 1 && WebServiceContextProcessor.isWebServiceContext(method.parameterType(0));
    }

    static boolean isWebServiceContext(Type fieldType) {
        return fieldType.kind() == Type.Kind.CLASS && fieldType.asClassType().name().equals((Object)CxfDotNames.WEBSERVICE_CONTEXT);
    }

    static String resourceNameToSetter(String resName) {
        return "set" + StringUtils.capitalize((String)resName);
    }

    static class ClassLevelResourceAnnotations {
        private final Map<DotName, Set<String>> fields = new HashMap<DotName, Set<String>>();
        private final Map<DotName, Set<String>> setters = new HashMap<DotName, Set<String>>();
        private final IndexView index;

        public ClassLevelResourceAnnotations(IndexView index) {
            this.index = index;
        }

        void handleResource(ClassInfo annnotatedClass, AnnotationInstance resourceAnnotation) {
            AnnotationValue name = resourceAnnotation.value("name");
            if (name == null || "".equals(name.asString())) {
                throw new IllegalStateException("@Resource annotation on " + annnotatedClass.name() + " must specify a value for 'name'");
            }
            String setterName = WebServiceContextProcessor.resourceNameToSetter(name.asString());
            if (!this.findSetterForResource(annnotatedClass, setterName) && !this.findFieldForResource(annnotatedClass, name.asString())) {
                throw new IllegalStateException("Could not find neither a setter or a field for @Resource(name = \"" + name + "\") in " + annnotatedClass.name() + " or in any of its superclasses.");
            }
        }

        boolean findSetterForResource(ClassInfo clInfo, String setterName) {
            MethodInfo method = clInfo.method(setterName, new Type[]{WEBSERVICE_CONTEXT_TYPE});
            if (method != null) {
                if (method.hasAnnotation(CxfDotNames.JAKARTA_ANNOTATION_RESOURCE) || method.hasAnnotation(CxfDotNames.INJECT)) {
                    return true;
                }
                this.setters.computeIfAbsent(clInfo.name(), k -> new HashSet()).add(setterName);
                return true;
            }
            DotName superName = clInfo.superName();
            if (superName != null && !CxfDotNames.JAVA_LANG_OBJECT.equals((Object)superName)) {
                return this.findSetterForResource(this.index.getClassByName(superName), setterName);
            }
            return false;
        }

        boolean findFieldForResource(ClassInfo clInfo, String fieldName) {
            FieldInfo field = clInfo.field(fieldName);
            if (field != null && field.type().name().equals((Object)CxfDotNames.WEBSERVICE_CONTEXT)) {
                if (field.hasAnnotation(CxfDotNames.JAKARTA_ANNOTATION_RESOURCE) || field.hasAnnotation(CxfDotNames.INJECT)) {
                    return true;
                }
                this.fields.computeIfAbsent(clInfo.name(), k -> new HashSet()).add(fieldName);
                return true;
            }
            DotName superName = clInfo.superName();
            if (superName != null && !CxfDotNames.JAVA_LANG_OBJECT.equals((Object)superName)) {
                return this.findSetterForResource(this.index.getClassByName(superName), fieldName);
            }
            return false;
        }

        public boolean containsField(DotName className, String fieldName) {
            Set<String> fieldNames = this.fields.get(className);
            return fieldNames != null && fieldNames.contains(fieldName);
        }

        public boolean containsSetter(DotName className, String setterName) {
            Set<String> fieldNames = this.setters.get(className);
            return fieldNames != null && fieldNames.contains(setterName);
        }
    }
}

