/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.ws.security;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CxfClientProducer;
import io.quarkiverse.cxf.transport.CxfHandler;
import io.quarkiverse.cxf.ws.security.CxfWsSecurityConfig;
import io.quarkiverse.cxf.ws.security.WssConfigurationConstant;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.ws.security.trust.STSClient;

@ApplicationScoped
public class WssFactoryCustomizer
implements CxfClientProducer.ClientFactoryCustomizer,
CxfHandler.EndpointFactoryCustomizer {
    @Inject
    CxfWsSecurityConfig config;

    public void customize(CXFClientInfo cxfClientInfo, JaxWsProxyFactoryBean factory) {
        String key = cxfClientInfo.getConfigKey();
        if (key != null && Optional.ofNullable(this.config.clients()).map(m -> m.containsKey(key)).orElse(false).booleanValue()) {
            CxfWsSecurityConfig.ClientSecurityConfig wssConfig = ((CxfWsSecurityConfig.ClientConfig)Optional.ofNullable(this.config.clients()).map(m1 -> (CxfWsSecurityConfig.ClientConfig)m1.get(key)).orElse(null)).security();
            this.customize(factory.getBus(), Kind.client, key, wssConfig, factory.getProperties()::put);
        }
    }

    public void customize(CXFServletInfo servletInfo, JaxWsServerFactoryBean factory) {
        String key = servletInfo.getRelativePath();
        if (key != null && Optional.ofNullable(this.config.endpoints()).map(m -> m.containsKey(key)).orElse(false).booleanValue()) {
            CxfWsSecurityConfig.ClientOrEndpointSecurityConfig wssConfig = ((CxfWsSecurityConfig.EndpointConfig)Optional.ofNullable(this.config.endpoints()).map(m1 -> (CxfWsSecurityConfig.EndpointConfig)m1.get(key)).orElse(null)).security();
            this.customize(factory.getBus(), Kind.endpoint, key, wssConfig, factory.getProperties()::put);
        }
    }

    private void customize(Bus bus, Kind kind, String key, CxfWsSecurityConfig.ClientOrEndpointSecurityConfig wssConfig, BiConsumer<String, Object> props) {
        WssFactoryCustomizer.consumeAnnotated(CxfWsSecurityConfig.ClientOrEndpointSecurityConfig.class, wssConfig, props);
        if (wssConfig instanceof CxfWsSecurityConfig.ClientSecurityConfig) {
            CxfWsSecurityConfig.StsClientConfig sts = ((CxfWsSecurityConfig.ClientSecurityConfig)wssConfig).sts();
            Optional<String> stsClient = sts.client();
            if (stsClient.isPresent()) {
                props.accept("security.sts.client", CXFRuntimeUtils.getInstance((String)stsClient.get(), (boolean)true));
            } else if (sts.wsdl().isPresent()) {
                STSClient client = new STSClient(BusFactory.getDefaultBus());
                client.setWsdlLocation(sts.wsdl().get());
                if (sts.serviceName().isEmpty()) {
                    throw new IllegalStateException("If you specify quarkus.cxf." + String.valueOf((Object)kind) + ".\"" + key + "\".security.sts.client.wsdl you must also specify quarkus.cxf." + String.valueOf((Object)kind) + ".\"" + key + "\".security.sts.client.service-name");
                }
                client.setServiceName(sts.serviceName().get());
                if (sts.endpointName().isEmpty()) {
                    throw new IllegalStateException("If you specify quarkus.cxf." + String.valueOf((Object)kind) + ".\"" + key + "\".security.sts.client.wsdl you must also specify quarkus.cxf." + String.valueOf((Object)kind) + ".\"" + key + "\".security.sts.client.endpoint-name");
                }
                client.setEndpointName(sts.endpointName().get());
                WssFactoryCustomizer.consumeAnnotated(CxfWsSecurityConfig.StsClientConfig.class, sts, client.getProperties()::put);
                props.accept("security.sts.client", client);
            }
        }
    }

    static void consumeAnnotated(Class<?> cl, Object config, BiConsumer<String, Object> consumer) {
        block8: for (Method method : cl.getDeclaredMethods()) {
            WssConfigurationConstant wssConfigurationConstant = method.getAnnotation(WssConfigurationConstant.class);
            if (wssConfigurationConstant == null) continue;
            Object value = null;
            try {
                value = method.invoke(config, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Could not invoke " + cl.getName() + "." + method.getName() + "()", e);
            }
            if (value instanceof Optional) {
                if (!((Optional)value).isPresent()) continue;
                value = ((Optional)value).get();
            }
            if (value == null) continue;
            String propKey = wssConfigurationConstant.key() != null && !wssConfigurationConstant.key().isEmpty() ? wssConfigurationConstant.key() : method.getName();
            switch (wssConfigurationConstant.transformer()) {
                case toString: {
                    consumer.accept(propKey, value.toString());
                    continue block8;
                }
                case beanRef: {
                    consumer.accept(propKey, CXFRuntimeUtils.getInstance((String)((String)value), (boolean)true));
                    continue block8;
                }
                case properties: {
                    Map map = (Map)value;
                    if (map.isEmpty()) continue block8;
                    Properties cryptoProps = new Properties();
                    cryptoProps.putAll((Map<?, ?>)map);
                    consumer.accept(propKey, cryptoProps);
                    continue block8;
                }
                case toInteger: {
                    consumer.accept(propKey, Integer.parseInt(value.toString()));
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + WssConfigurationConstant.Transformer.class.getName() + ": " + String.valueOf((Object)wssConfigurationConstant.transformer()));
                }
            }
        }
    }

    private static enum Kind {
        client,
        endpoint;

    }
}

