/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.test;

import io.quarkus.runtime.LaunchMode;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class QuarkusCxfClientTestUtil {
    private QuarkusCxfClientTestUtil() {
    }

    public static <T> T getClient(Class<T> serviceInterface, String path) {
        return QuarkusCxfClientTestUtil.getClient(QuarkusCxfClientTestUtil.getDefaultNameSpace(serviceInterface), serviceInterface, path);
    }

    public static <T> T getClient(String namespace, Class<T> serviceInterface, String path) {
        try {
            URL serviceUrl = new URL(QuarkusCxfClientTestUtil.getServerUrl() + path + "?wsdl");
            QName qName = new QName(namespace, serviceInterface.getSimpleName());
            Service service = Service.create((URL)serviceUrl, (QName)qName);
            return (T)service.getPort(serviceInterface);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getServerUrl() {
        Config config = ConfigProvider.getConfig();
        int port = LaunchMode.current().equals((Object)LaunchMode.TEST) ? ((Integer)config.getValue("quarkus.http.test-port", Integer.class)).intValue() : ((Integer)config.getValue("quarkus.http.port", Integer.class)).intValue();
        return String.format("http://localhost:%d", port);
    }

    public static String getEndpointUrl(Object port) {
        return (String)((BindingProvider)port).getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
    }

    public static String getDefaultNameSpace(Class<?> cl) {
        String pkg = cl.getName();
        int idx = pkg.lastIndexOf(46);
        if (idx != -1 && idx < pkg.length() - 1) {
            pkg = pkg.substring(0, idx);
        }
        String[] strs = pkg.split("\\.");
        StringBuilder b = new StringBuilder("http://");
        for (int i = strs.length - 1; i >= 0; --i) {
            if (i != strs.length - 1) {
                b.append(".");
            }
            b.append(strs[i]);
        }
        b.append("/");
        return b.toString();
    }

    public static String anyNs(String ... elementNames) {
        return Stream.of(elementNames).collect(Collectors.joining("']/*[local-name() = '", "/*[local-name() = '", "']"));
    }

    public static Predicate<String> messageExists(String messageKind, String payload) {
        return msg -> Pattern.compile("^" + messageKind + ".*\\QPayload: " + payload + "\n\\E$", 32).matcher((CharSequence)msg).matches();
    }
}

