/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpException;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.Cookies;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class VertxHttpClientHTTPConduit
extends HTTPConduit {
    private static final Logger LOG = LogUtils.getL7dLogger(VertxHttpClientHTTPConduit.class);
    private final HttpClientPool httpClientPool;
    private final String userAgent;

    public VertxHttpClientHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, HttpClientPool httpClientPool) throws IOException {
        super(b, ei, t);
        this.httpClientPool = httpClientPool;
        this.userAgent = Version.getCompleteVersionString();
    }

    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        String query;
        InetSocketAddress adr;
        TLSClientParameters clientParameters;
        RequestOptions requestOptions = new RequestOptions();
        URI uri = address.getURI();
        String scheme = uri.getScheme();
        message.put((Object)"http.scheme", (Object)scheme);
        HttpMethod method = VertxHttpClientHTTPConduit.getMethod(message);
        HttpVersion version = VertxHttpClientHTTPConduit.getVersion(message, csPolicy);
        boolean isHttps = "https".equals(uri.getScheme());
        if (isHttps) {
            clientParameters = this.findTLSClientParameters(message);
            if (clientParameters.getSSLSocketFactory() != null) {
                throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support SSLSocketFactory set via TLSClientParameters");
            }
            if (clientParameters.getSslContext() != null) {
                throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support SSLContext set via TLSClientParameters");
            }
            if (clientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
                throw new IllegalStateException(VertxHttpClientHTTPConduit.class.getName() + " does not support TLSClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory() returning true");
            }
            MessageTrustDecider decider2 = (MessageTrustDecider)message.get(MessageTrustDecider.class);
            if (decider2 != null || this.trustDecider != null) {
                trustDeciders = new ArrayList(2);
                if (this.trustDecider != null) {
                    trustDeciders.add(this.trustDecider);
                }
                if (decider2 != null) {
                    trustDeciders.add(decider2);
                }
            } else {
                trustDeciders = Collections.emptyList();
            }
        } else {
            clientParameters = null;
        }
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, uri);
        if (proxy != null && (adr = (InetSocketAddress)proxy.address()) != null) {
            requestOptions.setProxyOptions(new ProxyOptions().setHost(adr.getHostName()).setPort(adr.getPort()).setType(VertxHttpClientHTTPConduit.toProxyType(proxy.type())));
        }
        String pathAndQuery = (query = uri.getQuery()) != null && !query.isEmpty() ? uri.getPath() + "?" + query : uri.getPath();
        requestOptions.setMethod(method).setPort(Integer.valueOf(uri.getPort())).setHost(uri.getHost()).setURI(pathAndQuery).setConnectTimeout((long)VertxHttpClientHTTPConduit.determineConnectionTimeout((Message)message, (HTTPClientPolicy)csPolicy));
        RequestContext requestContext = new RequestContext(uri, requestOptions, new HttpClientPool.ClientSpec(version, clientParameters), VertxHttpClientHTTPConduit.determineReceiveTimeout((Message)message, (HTTPClientPolicy)csPolicy));
        message.put(RequestContext.class, (Object)requestContext);
    }

    static ProxyType toProxyType(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return ProxyType.HTTP;
            }
            case SOCKS: {
                return ProxyType.SOCKS4;
            }
        }
        throw new IllegalArgumentException("Unexpected " + Proxy.Type.class.getName() + " " + type);
    }

    protected OutputStream createOutputStream(Message message, boolean possibleRetransmit, boolean isChunking, int chunkThreshold) throws IOException {
        RequestContext requestContext = (RequestContext)message.get(RequestContext.class);
        ResponseHandler responseHandler = new ResponseHandler(requestContext.uri, message, this.cookies, this.incomingObserver);
        RequestBodyHandler requestBodyHandler = new RequestBodyHandler(message, requestContext.uri, this.userAgent, this.httpClientPool, requestContext.requestOptions, requestContext.clientSpec, requestContext.receiveTimeoutMs, responseHandler);
        return new RequestBodyOutputStream(chunkThreshold, requestBodyHandler);
    }

    static HttpVersion getVersion(Message message, HTTPClientPolicy csPolicy) {
        String verc = (String)message.getContextualProperty("org.apache.cxf.transport.http.forceVersion");
        if (verc == null) {
            verc = csPolicy.getVersion();
        }
        if (verc == null) {
            verc = "1.1";
        }
        HttpVersion v = switch (verc) {
            case "2" -> HttpVersion.HTTP_2;
            case "auto", "1.1" -> HttpVersion.HTTP_1_1;
            case "1.0" -> HttpVersion.HTTP_1_0;
            default -> throw new IllegalArgumentException("Unexpected HTTP protocol version " + verc);
        };
        return v;
    }

    static HttpMethod getMethod(Message message) {
        HttpMethod method;
        String rawRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (rawRequestMethod == null) {
            method = HttpMethod.POST;
            message.put((Object)"org.apache.cxf.request.method", (Object)"POST");
        } else {
            method = HttpMethod.valueOf((String)rawRequestMethod);
        }
        return method;
    }

    TLSClientParameters findTLSClientParameters(Message message) {
        TLSClientParameters clientParameters = (TLSClientParameters)message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        if (clientParameters == null) {
            clientParameters = new TLSClientParameters();
        }
        return clientParameters;
    }

    record RequestContext(URI uri, RequestOptions requestOptions, HttpClientPool.ClientSpec clientSpec, long receiveTimeoutMs) {
    }

    static class ResponseHandler
    implements IOEHandler<ResponseEvent> {
        private static final Collection<Integer> DEFAULT_SERVICE_NOT_AVAILABLE_ON_HTTP_STATUS_CODES = Arrays.asList(404, 429, 503);
        private final URI url;
        private final Message outMessage;
        private final Cookies cookies;
        private final MessageObserver incomingObserver;

        public ResponseHandler(URI url, Message outMessage, Cookies cookies, MessageObserver incomingObserver) {
            this.url = url;
            this.outMessage = outMessage;
            this.cookies = cookies;
            this.incomingObserver = incomingObserver;
        }

        @Override
        public void handle(ResponseEvent responseEvent) throws IOException {
            String charset;
            String normalizedEncoding;
            HttpClientResponse response = responseEvent.response;
            Exchange exchange = this.outMessage.getExchange();
            int responseCode = ResponseHandler.doProcessResponseCode(this.url, response, exchange, this.outMessage);
            InputStream in = null;
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            ResponseHandler.updateResponseHeaders(response, (Message)inMessage, this.cookies);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            if (MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.http.set.response.message", (boolean)false)) {
                inMessage.put((Object)"http.responseMessage", (Object)response.statusMessage());
            }
            ResponseHandler.propagateConduit(exchange, (Message)inMessage);
            if ((!ResponseHandler.doProcessResponse(this.outMessage, responseCode) || 202 == responseCode) && MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.process202Response", (boolean)true)) {
                in = ResponseHandler.getPartialResponse(response, responseEvent.responseBodyInputStream);
                if (in == null || !MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.processOneWayResponse", (boolean)false)) {
                    ClientCallback cc;
                    if (ResponseHandler.isOneway(exchange) && responseCode > 300) {
                        String msg = "HTTP response '" + responseCode + ": " + response.statusMessage() + "' when communicating with " + this.url.toString();
                        throw new VertxHttpException(msg);
                    }
                    Endpoint ep = exchange.getEndpoint();
                    if (null != ep && null != ep.getEndpointInfo() && null == ep.getEndpointInfo().getProperty("org.apache.cxf.ws.addressing.MAPAggregator.decoupledDestination") && null != (cc = (ClientCallback)exchange.remove(ClientCallback.class))) {
                        cc.handleResponse(null, null);
                    }
                    exchange.put((Object)"IN_CHAIN_COMPLETE", (Object)Boolean.TRUE);
                    exchange.setInMessage((Message)inMessage);
                    if (MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.transport.propagate202Response", (boolean)false)) {
                        this.incomingObserver.onMessage((Message)inMessage);
                    }
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
            }
            if ((normalizedEncoding = HttpHeaderHelper.mapCharset((String)(charset = HttpHeaderHelper.findCharset((String)((String)inMessage.get((Object)"Content-Type")))))) == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{charset}).toString();
                throw new VertxHttpException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
            if (in == null) {
                in = responseEvent.responseBodyInputStream;
            }
            inMessage.setContent(InputStream.class, (Object)in);
            this.incomingObserver.onMessage((Message)inMessage);
        }

        static int doProcessResponseCode(URI uri, HttpClientResponse response, Exchange exchange, Message outMessage) throws IOException {
            int rc = response.statusCode();
            if (rc == -1) {
                LOG.warning("HTTP Response code appears to be corrupted");
            }
            if (exchange != null) {
                exchange.put((Object)Message.RESPONSE_CODE, (Object)rc);
                Collection serviceNotAvailableOnHttpStatusCodes = MessageUtils.getContextualIntegers((Message)outMessage, (String)"org.apache.cxf.transport.service_not_available_on_http_status_codes", DEFAULT_SERVICE_NOT_AVAILABLE_ON_HTTP_STATUS_CODES);
                if (serviceNotAvailableOnHttpStatusCodes.contains(rc)) {
                    exchange.put((Object)"org.apache.cxf.transport.service_not_available", (Object)true);
                }
            }
            if (!(rc < 400 || rc == 500 || MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.transport.no_io_exceptions") || rc <= 400 && MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.transport.process_fault_on_http_400"))) {
                throw new HTTPException(rc, response.statusMessage(), uri.toURL());
            }
            return rc;
        }

        static void updateResponseHeaders(HttpClientResponse response, Message inMessage, Cookies cookies) {
            Headers h = new Headers(inMessage);
            inMessage.put((Object)"Content-Type", (Object)ResponseHandler.readHeaders(response, h));
            cookies.readFromHeaders(h);
        }

        static InputStream getPartialResponse(HttpClientResponse response, InputStream responseBodyInputStream) {
            InputStream in = null;
            int responseCode = response.statusCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                String transferEncoding;
                MultiMap headers = response.headers();
                String rawContentLength = headers.get("Content-Length");
                int contentLength = 0;
                if (rawContentLength != null) {
                    try {
                        contentLength = Integer.parseInt(rawContentLength);
                    }
                    catch (NumberFormatException e) {
                        LOG.fine("Could not parse Content-Length value " + rawContentLength);
                    }
                }
                boolean isChunked = (transferEncoding = headers.get("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(transferEncoding);
                String connection = headers.get("Connection");
                boolean bl = isEofTerminated = connection != null && "close".equalsIgnoreCase(connection);
                if (contentLength > 0) {
                    in = responseBodyInputStream;
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(responseBodyInputStream);
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        static String readHeaders(HttpClientResponse response, Headers h) {
            Map dest = h.headerMap();
            String ct = null;
            for (Map.Entry en : response.headers().entries()) {
                String key = (String)en.getKey();
                dest.computeIfAbsent(key, k -> new ArrayList()).add((String)en.getValue());
                if (!"Content-Type".equalsIgnoreCase(key)) continue;
                ct = (String)en.getValue();
            }
            return ct;
        }

        static void propagateConduit(Exchange exchange, Message in) {
            Message out;
            if (exchange != null && (out = exchange.getOutMessage()) != null) {
                in.put(Conduit.class, (Object)((Conduit)out.get(Conduit.class)));
            }
        }

        static boolean doProcessResponse(Message message, int responseCode) {
            if (!ResponseHandler.isOneway(message.getExchange())) {
                return true;
            }
            return responseCode == 500 && MessageUtils.getContextualBoolean((Message)message, (String)"org.apache.cxf.oneway.robust", (boolean)false);
        }

        static boolean isOneway(Exchange exchange) {
            return exchange != null && exchange.isOneWay();
        }
    }

    static class RequestBodyHandler
    implements IOEHandler<RequestBodyEvent> {
        private final Message outMessage;
        private final URI url;
        private final String userAgent;
        private final HttpClientPool clientPool;
        private final RequestOptions requestOptions;
        private final HttpClientPool.ClientSpec clientSpec;
        private final long receiveTimeoutDeadline;
        private final IOEHandler<ResponseEvent> responseHandler;
        private boolean firstEvent = true;
        private Result<HttpClientRequest> request;
        private Result<ResponseEvent> response;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition requestReady = this.lock.newCondition();
        private final Condition requestWriteable = this.lock.newCondition();
        private final Condition responseReceived = this.lock.newCondition();
        private boolean drainHandlerRegistered;
        private boolean waitingForDrain;

        public RequestBodyHandler(Message outMessage, URI url, String userAgent, HttpClientPool clientPool, RequestOptions requestOptions, HttpClientPool.ClientSpec clientSpec, long receiveTimeoutMs, IOEHandler<ResponseEvent> responseHandler) {
            this.outMessage = outMessage;
            this.url = url;
            this.userAgent = userAgent;
            this.clientPool = clientPool;
            this.requestOptions = requestOptions;
            this.clientSpec = clientSpec;
            this.receiveTimeoutDeadline = System.currentTimeMillis() + receiveTimeoutMs;
            this.responseHandler = responseHandler;
        }

        @Override
        public void handle(RequestBodyEvent event) throws IOException {
            if (this.firstEvent) {
                this.firstEvent = false;
                HttpClient client = this.clientPool.getClient(this.clientSpec);
                switch (event.eventType()) {
                    case NON_FINAL_CHUNK: 
                    case FINAL_CHUNK: {
                        break;
                    }
                    case COMPLETE_BODY: {
                        this.requestOptions.putHeader("Content-Length", String.valueOf(event.buffer().length()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected " + RequestBodyEvent.RequestBodyEventType.class.getName() + ": " + event.eventType());
                    }
                }
                RequestBodyHandler.setProtocolHeaders(this.outMessage, this.requestOptions, this.userAgent);
                client.request(this.requestOptions).onSuccess(req -> {
                    switch (event.eventType()) {
                        case NON_FINAL_CHUNK: {
                            req.setChunked(true).write((Object)event.buffer()).onFailure(this::failResponse);
                            this.lock.lock();
                            try {
                                this.request = new Result<HttpClientRequest>((HttpClientRequest)req, null);
                                this.requestReady.signal();
                                break;
                            }
                            finally {
                                this.lock.unlock();
                            }
                        }
                        case FINAL_CHUNK: 
                        case COMPLETE_BODY: {
                            this.finishRequest((HttpClientRequest)req, event.buffer());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected " + RequestBodyEvent.RequestBodyEventType.class.getName() + ": " + event.eventType());
                        }
                    }
                }).onFailure(t -> {
                    this.lock.lock();
                    try {
                        this.request = Result.failure(t);
                        this.requestReady.signal();
                        this.response = Result.failure(t);
                        this.responseReceived.signal();
                    }
                    finally {
                        this.lock.unlock();
                    }
                });
                switch (event.eventType()) {
                    case NON_FINAL_CHUNK: {
                        break;
                    }
                    case FINAL_CHUNK: 
                    case COMPLETE_BODY: {
                        this.responseHandler.handle(this.awaitResponse());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected " + RequestBodyEvent.RequestBodyEventType.class.getName() + ": " + event.eventType());
                    }
                }
            } else {
                HttpClientRequest req2 = this.awaitRequest();
                switch (event.eventType()) {
                    case NON_FINAL_CHUNK: {
                        req2.write((Object)event.buffer()).onFailure(this::failResponse);
                        break;
                    }
                    case FINAL_CHUNK: 
                    case COMPLETE_BODY: {
                        this.finishRequest(req2, event.buffer());
                        this.responseHandler.handle(this.awaitResponse());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected " + RequestBodyEvent.RequestBodyEventType.class.getName() + ": " + event.eventType());
                    }
                }
            }
        }

        void finishRequest(HttpClientRequest req, Buffer buffer) {
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                ExceptionAwarePipedInputStream pipedInputStream = new ExceptionAwarePipedInputStream(pipedOutputStream);
                req.response().onComplete(ar -> {
                    if (ar.succeeded()) {
                        RequestBodyHandler.pipe((HttpClientResponse)ar.result(), pipedOutputStream, pipedInputStream);
                    } else if (ar.cause() instanceof IOException) {
                        pipedInputStream.setException((IOException)ar.cause());
                    } else {
                        pipedInputStream.setException(new IOException(ar.cause()));
                    }
                    this.lock.lock();
                    try {
                        this.response = new Result<ResponseEvent>(new ResponseEvent((HttpClientResponse)ar.result(), pipedInputStream), ar.cause());
                        this.responseReceived.signal();
                    }
                    finally {
                        this.lock.unlock();
                    }
                });
                req.end(buffer).onFailure(this::failResponse);
            }
            catch (IOException e) {
                throw new VertxHttpException(e);
            }
        }

        void failResponse(Throwable t) {
            this.lock.lock();
            try {
                this.response = Result.failure(t);
                this.responseReceived.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        static void setProtocolHeaders(Message outMessage, RequestOptions requestOptions, String userAgent) throws IOException {
            MultiMap outHeaders;
            Object contentType = outMessage.get((Object)"Content-Type");
            if (contentType instanceof String) {
                requestOptions.putHeader("Content-Type", (String)contentType);
                outHeaders = requestOptions.getHeaders();
            } else {
                outHeaders = HttpHeaders.headers();
                requestOptions.setHeaders(outHeaders);
            }
            Headers h = new Headers(outMessage);
            boolean addHeaders = MessageUtils.getContextualBoolean((Message)outMessage, (String)"org.apache.cxf.http.add-headers", (boolean)false);
            for (Map.Entry header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase((String)header.getKey())) {
                    values = (List)header.getValue();
                    for (String s : values) {
                        outHeaders.add("Cookie", s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase((String)header.getKey())) {
                    values = (List)header.getValue();
                    int len = values.size();
                    switch (len) {
                        case 0: {
                            outHeaders.set((String)header.getKey(), "");
                            break;
                        }
                        case 1: {
                            outHeaders.set((String)header.getKey(), (String)values.get(0));
                            break;
                        }
                        default: {
                            StringBuilder b = new StringBuilder();
                            for (int i = 0; i < len; ++i) {
                                b.append((String)values.get(i));
                                if (i + 1 >= len) continue;
                                b.append(',');
                            }
                            outHeaders.set((String)header.getKey(), b.toString());
                        }
                    }
                }
                if (outHeaders.contains("User-Agent")) continue;
                outHeaders.set("User-Agent", userAgent);
            }
        }

        ResponseEvent awaitResponse() throws IOException {
            if (this.response == null) {
                this.lock.lock();
                try {
                    if (!(this.response != null || this.responseReceived.await(this.receiveTimeout(), TimeUnit.MILLISECONDS) && this.response != null)) {
                        throw new SocketTimeoutException("Timeout waiting for HTTP response from " + this.url);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting for HTTP response from " + this.url, e);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.response.succeeded()) {
                return this.response.result();
            }
            Throwable e = this.response.cause();
            throw new IOException("Unable to receive HTTP response from " + this.url, e);
        }

        HttpClientRequest awaitRequest() throws IOException {
            if (this.request == null) {
                this.lock.lock();
                try {
                    if (!(this.request != null || this.requestReady.await(this.requestOptions.getConnectTimeout(), TimeUnit.MILLISECONDS) && this.request != null)) {
                        throw new SocketTimeoutException("Timeout waiting for HTTP connect to " + this.url);
                    }
                    if (this.request.succeeded()) {
                        this.awaitWriteable(this.request.result());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting for HTTP response from " + this.url, e);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.request.succeeded()) {
                return this.request.result();
            }
            Throwable e = this.request.cause();
            throw new IOException("Unable to connect to " + this.url, e);
        }

        static void pipe(HttpClientResponse response, PipedOutputStream pipedOutputStream, ExceptionAwarePipedInputStream pipedInputStream) {
            response.handler(buffer -> {
                try {
                    pipedOutputStream.write(buffer.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            response.endHandler(v -> {
                try {
                    pipedOutputStream.close();
                }
                catch (IOException e) {
                    pipedInputStream.setException(e);
                }
            });
            response.exceptionHandler(e -> {
                IOException ioe = e instanceof IOException ? (IOException)e : new IOException((Throwable)e);
                pipedInputStream.setException(ioe);
            });
        }

        void awaitWriteable(HttpClientRequest request) throws IOException, InterruptedException {
            assert (this.lock.isHeldByCurrentThread());
            while (request.writeQueueFull()) {
                if (this.request.cause() != null) {
                    throw new IOException(this.request.cause());
                }
                if (Context.isOnEventLoopThread()) {
                    throw new IllegalStateException("Attempting a blocking write on io thread");
                }
                if (!this.drainHandlerRegistered) {
                    this.drainHandlerRegistered = true;
                    Handler<Void> drainHandler = new Handler<Void>(){

                        public void handle(Void event) {
                            if (waitingForDrain) {
                                lock.lock();
                                try {
                                    requestWriteable.signal();
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        }
                    };
                    request.drainHandler((Handler)drainHandler);
                }
                try {
                    this.waitingForDrain = true;
                    this.requestWriteable.await(this.receiveTimeout(), TimeUnit.MILLISECONDS);
                }
                finally {
                    this.waitingForDrain = false;
                }
            }
        }

        long receiveTimeout() throws SocketTimeoutException {
            long timeout = this.receiveTimeoutDeadline - System.currentTimeMillis();
            if (timeout <= 0L) {
                throw new SocketTimeoutException("Timeout waiting for HTTP response from " + this.url);
            }
            return timeout;
        }
    }

    public static interface IOEHandler<E> {
        public void handle(E var1) throws IOException;
    }

    static class RequestBodyOutputStream
    extends OutputStream {
        private Buffer buffer;
        private final int chunkSize;
        private final IOEHandler<RequestBodyEvent> bodyHandler;
        private boolean closed = false;
        private boolean firstChunkSent = false;

        public RequestBodyOutputStream(int chunkSize, IOEHandler<RequestBodyEvent> bodyHandler) {
            this.chunkSize = chunkSize;
            this.bodyHandler = bodyHandler;
            this.buffer = Buffer.buffer((int)chunkSize);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.chunkSize > 0) {
                int remainingCapacity;
                while ((remainingCapacity = this.chunkSize - this.buffer.length()) < len) {
                    this.buffer.appendBytes(b, off, remainingCapacity);
                    off += remainingCapacity;
                    len -= remainingCapacity;
                    Buffer buf = this.buffer;
                    this.bodyHandler.handle(new RequestBodyEvent(buf, RequestBodyEvent.RequestBodyEventType.NON_FINAL_CHUNK));
                    this.firstChunkSent = true;
                    this.buffer = Buffer.buffer((int)this.chunkSize);
                }
            }
            if (len > 0) {
                this.buffer.appendBytes(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.chunkSize > 0 && this.buffer.length() == this.chunkSize) {
                Buffer buf = this.buffer;
                this.bodyHandler.handle(new RequestBodyEvent(buf, RequestBodyEvent.RequestBodyEventType.NON_FINAL_CHUNK));
                this.firstChunkSent = true;
                this.buffer = Buffer.buffer((int)this.chunkSize);
            }
            this.buffer.appendByte((byte)b);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                super.close();
                RequestBodyEvent.RequestBodyEventType eventType = this.firstChunkSent ? RequestBodyEvent.RequestBodyEventType.FINAL_CHUNK : RequestBodyEvent.RequestBodyEventType.COMPLETE_BODY;
                Buffer buf = this.buffer;
                this.buffer = null;
                this.bodyHandler.handle(new RequestBodyEvent(buf, eventType));
            }
        }
    }

    static class ExceptionAwarePipedInputStream
    extends PipedInputStream {
        private IOException exception;
        private final Object lock = new Object();

        public ExceptionAwarePipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setException(IOException exception) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception == null) {
                    this.exception = exception;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            return super.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            return super.read(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            super.close();
        }
    }

    record Result<T>(T result, Throwable cause) {
        static <T> Result<T> failure(Throwable cause) {
            return new Result<Object>(null, cause);
        }

        boolean succeeded() {
            return this.cause == null;
        }
    }

    record ResponseEvent(HttpClientResponse response, InputStream responseBodyInputStream) {
    }

    record RequestBodyEvent(Buffer buffer, RequestBodyEventType eventType) {

        public static enum RequestBodyEventType {
            NON_FINAL_CHUNK,
            FINAL_CHUNK,
            COMPLETE_BODY;

        }
    }
}

