/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpException;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.DefaultSslContextFactory;
import io.vertx.core.spi.tls.SslContextFactory;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transport.https.httpclient.DefaultHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.PublicSuffixMatcherLoader;

public class HttpClientPool {
    private final Map<ClientSpec, HttpClient> clients = new ConcurrentHashMap<ClientSpec, HttpClient>();
    private final Vertx vertx;
    private static final Provider PROVIDER = new Provider("", "0.0", ""){};

    public HttpClientPool(Vertx vertx) {
        this.vertx = vertx;
    }

    public HttpClient getClient(ClientSpec spec) {
        return this.clients.computeIfAbsent(spec, v -> {
            HttpClientOptions opts = new HttpClientOptions().setProtocolVersion(spec.getVersion());
            if (spec.isSsl()) {
                opts.setSsl(true).setTrustAll(true).setSslEngineOptions(spec.createSslEngineOptions());
            }
            return this.vertx.createHttpClient(opts);
        });
    }

    public static class ClientSpec {
        protected static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
        private final HttpVersion httpVersion;
        private final KeyManager[] keyManagers;
        private final TrustManager[] trustManagers;
        private final Set<String> cipherSuites;
        private final HostnameVerifier hostNameVerifier;
        private final int hashCode;
        private final boolean ssl;
        private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        private static final HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER;

        public ClientSpec(HttpVersion version, TLSClientParameters params) {
            this.httpVersion = version;
            int h = 31 + this.httpVersion.hashCode();
            if (params != null) {
                String[] css;
                KeyManager[] kms = params.getKeyManagers();
                if (kms == null) {
                    kms = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultKeyStoreManagers((Logger)LOG);
                }
                try {
                    kms = SSLUtils.configureKeyManagersWithCertAlias((TLSParameterBase)params, (KeyManager[])kms);
                }
                catch (GeneralSecurityException e) {
                    throw new VertxHttpException(e);
                }
                this.keyManagers = kms;
                Object[] tms = params.getTrustManagers();
                if (tms == null) {
                    tms = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultTrustStoreManagers((Logger)LOG);
                }
                this.hostNameVerifier = ClientSpec.getHostnameVerifier(params);
                this.trustManagers = (TrustManager[])Stream.of(tms).map(t -> new X509TrustManagerWrapper((X509ExtendedTrustManager)t, this.hostNameVerifier)).toArray(TrustManager[]::new);
                try {
                    css = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude((List)params.getCipherSuites(), (FiltersType)params.getCipherSuitesFilter(), (String[])SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites(), (String[])Http2SecurityUtil.CIPHERS.toArray(new String[0]), (Logger)LOG);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new VertxHttpException(e);
                }
                this.cipherSuites = new LinkedHashSet<String>(Arrays.asList(css));
                h = 31 * h + Arrays.hashCode(this.keyManagers);
                h = 31 * h + Arrays.hashCode(tms);
                h = 31 * h + this.hostNameVerifier.hashCode();
                h = 31 * h + this.cipherSuites.hashCode();
                this.ssl = true;
            } else {
                this.keyManagers = null;
                this.trustManagers = null;
                this.hostNameVerifier = null;
                this.cipherSuites = null;
                this.ssl = false;
            }
            this.hashCode = h;
        }

        public HttpVersion getVersion() {
            return this.httpVersion;
        }

        public SSLEngineOptions createSslEngineOptions() {
            return new CxfSSLEngineOptions(new CxfSslContextFactory(this.toSslContex()));
        }

        SslContext toSslContex() {
            SslContextFactory builder = new DefaultSslContextFactory(SslProvider.JDK, true).forClient(true);
            try {
                return builder.enabledCipherSuites(this.cipherSuites).useAlpn(false).trustManagerFactory((TrustManagerFactory)new CxfTrustManagerFactory(this.trustManagers)).keyMananagerFactory((KeyManagerFactory)new CxfKeyManagerFactory(this.keyManagers)).clientAuth(ClientAuth.REQUIRE).create();
            }
            catch (SSLException e) {
                throw new VertxHttpException(e);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSpec other = (ClientSpec)obj;
            return this.httpVersion == other.httpVersion && Objects.equals(this.cipherSuites, other.cipherSuites) && Arrays.equals(this.keyManagers, other.keyManagers) && Arrays.equals(this.trustManagers, other.trustManagers);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        static HostnameVerifier getHostnameVerifier(TLSClientParameters tlsClientParameters) {
            if (tlsClientParameters.getHostnameVerifier() != null) {
                return tlsClientParameters.getHostnameVerifier();
            }
            if (tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier()) {
                return HttpsURLConnection.getDefaultHostnameVerifier();
            }
            if (tlsClientParameters.isDisableCNCheck()) {
                return ALLOW_ALL_HOSTNAME_VERIFIER;
            }
            return DEFAULT_HOSTNAME_VERIFIER;
        }

        static {
            TLSClientParameters params = new TLSClientParameters();
            params.setDisableCNCheck(true);
            ALLOW_ALL_HOSTNAME_VERIFIER = SSLUtils.getHostnameVerifier((TLSClientParameters)params);
        }
    }

    static class CxfKeyManagerFactory
    extends KeyManagerFactory {
        CxfKeyManagerFactory(final KeyManager ... km) {
            super(new KeyManagerFactorySpi(){

                @Override
                protected void engineInit(KeyStore keyStore, char[] pwd) throws KeyStoreException {
                }

                @Override
                protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
                }

                @Override
                protected KeyManager[] engineGetKeyManagers() {
                    return km;
                }
            }, PROVIDER, "");
        }
    }

    static class SSLSessionWrapper
    implements SSLSession {
        SSLSession session;
        Certificate[] certificates;

        SSLSessionWrapper(SSLSession s, Certificate[] certs) {
            this.certificates = certs;
            this.session = s;
        }

        @Override
        public byte[] getId() {
            return this.session.getId();
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return this.session.getSessionContext();
        }

        @Override
        public long getCreationTime() {
            return this.session.getCreationTime();
        }

        @Override
        public long getLastAccessedTime() {
            return this.session.getLastAccessedTime();
        }

        @Override
        public void invalidate() {
            this.session.invalidate();
        }

        @Override
        public boolean isValid() {
            return this.session.isValid();
        }

        @Override
        public void putValue(String s, Object o) {
            this.session.putValue(s, o);
        }

        @Override
        public Object getValue(String s) {
            return this.session.getValue(s);
        }

        @Override
        public void removeValue(String s) {
            this.session.removeValue(s);
        }

        @Override
        public String[] getValueNames() {
            return this.session.getValueNames();
        }

        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return this.certificates;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return this.session.getLocalCertificates();
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            return this.session.getPeerPrincipal();
        }

        @Override
        public Principal getLocalPrincipal() {
            return this.session.getLocalPrincipal();
        }

        @Override
        public String getCipherSuite() {
            return this.session.getCipherSuite();
        }

        @Override
        public String getProtocol() {
            return this.session.getProtocol();
        }

        @Override
        public String getPeerHost() {
            return this.session.getPeerHost();
        }

        @Override
        public int getPeerPort() {
            return this.session.getPeerPort();
        }

        @Override
        public int getPacketBufferSize() {
            return this.session.getPacketBufferSize();
        }

        @Override
        public int getApplicationBufferSize() {
            return this.session.getApplicationBufferSize();
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            return this.session.getPeerCertificateChain();
        }
    }

    static class SSLEngineWrapper
    extends SSLEngine {
        final SSLEngine delegate;

        SSLEngineWrapper(SSLEngine delegate) {
            this.delegate = delegate;
        }

        @Override
        public SSLParameters getSSLParameters() {
            SSLParameters params = this.delegate.getSSLParameters();
            params.setEndpointIdentificationAlgorithm(null);
            return params;
        }

        @Override
        public SSLSession getHandshakeSession() {
            return this.delegate.getHandshakeSession();
        }

        @Override
        public void beginHandshake() throws SSLException {
            this.delegate.beginHandshake();
        }

        @Override
        public void closeInbound() throws SSLException {
            this.delegate.closeInbound();
        }

        @Override
        public void closeOutbound() {
            this.delegate.closeOutbound();
        }

        @Override
        public Runnable getDelegatedTask() {
            return this.delegate.getDelegatedTask();
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.delegate.getEnableSessionCreation();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.delegate.getEnabledCipherSuites();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.delegate.getEnabledProtocols();
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return this.delegate.getHandshakeStatus();
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.delegate.getNeedClientAuth();
        }

        @Override
        public SSLSession getSession() {
            return this.delegate.getSession();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.delegate.getSupportedProtocols();
        }

        @Override
        public boolean getUseClientMode() {
            return this.delegate.getUseClientMode();
        }

        @Override
        public boolean getWantClientAuth() {
            return this.delegate.getWantClientAuth();
        }

        @Override
        public boolean isInboundDone() {
            return this.delegate.isInboundDone();
        }

        @Override
        public boolean isOutboundDone() {
            return this.delegate.isInboundDone();
        }

        @Override
        public void setEnableSessionCreation(boolean arg0) {
            this.delegate.setEnableSessionCreation(arg0);
        }

        @Override
        public void setEnabledCipherSuites(String[] arg0) {
            this.delegate.setEnabledCipherSuites(arg0);
        }

        @Override
        public void setEnabledProtocols(String[] arg0) {
            this.delegate.setEnabledProtocols(arg0);
        }

        @Override
        public void setNeedClientAuth(boolean arg0) {
            this.delegate.setNeedClientAuth(arg0);
        }

        @Override
        public void setUseClientMode(boolean arg0) {
            this.delegate.setUseClientMode(arg0);
        }

        @Override
        public void setWantClientAuth(boolean arg0) {
            this.delegate.setWantClientAuth(arg0);
        }

        @Override
        public SSLEngineResult unwrap(ByteBuffer arg0, ByteBuffer[] arg1, int arg2, int arg3) throws SSLException {
            return null;
        }

        @Override
        public SSLEngineResult wrap(ByteBuffer[] arg0, int arg1, int arg2, ByteBuffer arg3) throws SSLException {
            return null;
        }
    }

    static class X509TrustManagerWrapper
    extends X509ExtendedTrustManager {
        private final X509TrustManager delegate;
        private final X509ExtendedTrustManager extendedDelegate;
        private final HostnameVerifier verifier;

        X509TrustManagerWrapper(X509TrustManager delegate, HostnameVerifier hnv) {
            this.delegate = delegate;
            this.verifier = hnv;
            this.extendedDelegate = delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : null;
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s) throws CertificateException {
            this.delegate.checkClientTrusted(chain, s);
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s, Socket socket) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkClientTrusted(chain, s, socket);
            } else {
                this.delegate.checkClientTrusted(chain, s);
            }
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s, SSLEngine sslEngine) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkClientTrusted(chain, s, sslEngine);
            } else {
                this.delegate.checkClientTrusted(chain, s);
            }
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s) throws CertificateException {
            System.out.println("cst1: " + s);
            this.delegate.checkServerTrusted(chain, s);
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s, Socket socket) throws CertificateException {
            System.out.println("cst2: " + s);
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkServerTrusted(chain, s, socket);
            } else {
                this.delegate.checkServerTrusted(chain, s);
            }
        }

        private String getHostName(List<SNIServerName> names) {
            if (names == null) {
                return null;
            }
            for (SNIServerName n : names) {
                if (n.getType() != 0 || !(n instanceof SNIHostName)) continue;
                SNIHostName hostname = (SNIHostName)n;
                return hostname.getAsciiName();
            }
            return null;
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s, SSLEngine engine) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkServerTrusted(chain, s, new SSLEngineWrapper(engine));
                SSLSession session = engine.getHandshakeSession();
                List<SNIServerName> names = null;
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    names = extSession.getRequestedServerNames();
                }
                boolean identifiable = false;
                String peerHost = session.getPeerHost();
                String hostname = this.getHostName(names);
                session = new SSLSessionWrapper(session, chain);
                if (hostname != null && this.verifier.verify(hostname, session)) {
                    identifiable = true;
                }
                if (!identifiable && !this.verifier.verify(peerHost, session)) {
                    throw new CertificateException("The https URL hostname " + peerHost + " does not match the Common Name (CN) on the server certificate in the client's truststore. Make sure server certificate is correct, or to disable this check (NOT recommended for production) set the CXF client TLS configuration property \"disableCNCheck\" to true.");
                }
            } else {
                this.delegate.checkServerTrusted(chain, s);
            }
        }

        @Override
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }

    static class CxfTrustManagerFactory
    extends TrustManagerFactory {
        CxfTrustManagerFactory(final TrustManager ... tm) {
            super(new TrustManagerFactorySpi(){

                @Override
                protected void engineInit(KeyStore keyStore) throws KeyStoreException {
                }

                @Override
                protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
                }

                @Override
                protected TrustManager[] engineGetTrustManagers() {
                    return tm;
                }
            }, PROVIDER, "");
        }
    }

    public static class CxfSSLEngineOptions
    extends SSLEngineOptions {
        private final SslContextFactory sslContextFactory;

        public CxfSSLEngineOptions(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
        }

        public SSLEngineOptions copy() {
            return new CxfSSLEngineOptions(this.sslContextFactory);
        }

        public SslContextFactory sslContextFactory() {
            return this.sslContextFactory;
        }
    }

    public record CxfSslContextFactory(SslContext create) implements SslContextFactory
    {
    }
}

