/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.QuarkusJaxWsServiceFactoryBean;
import io.quarkus.arc.Unremovable;
import java.util.ArrayList;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.jboss.logging.Logger;

@Singleton
@Unremovable
public class CXFQuarkusServlet
extends CXFNonSpringServlet {
    private static final Logger LOGGER = Logger.getLogger(CXFQuarkusServlet.class);

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn((Object)("failed to load class " + className));
            return null;
        }
    }

    private Object getInstance(String className) {
        Class<?> classObj = this.loadClass(className);
        try {
            return classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void loadBus(ServletConfig servletConfig) {
        LOGGER.info((Object)"Load CXF bus");
        super.loadBus(servletConfig);
    }

    public void build(CXFServletInfos cxfServletInfos) {
        if (cxfServletInfos == null || cxfServletInfos.getInfos().size() == 0) {
            LOGGER.warn((Object)"no info transmit to servlet");
            return;
        }
        Bus bus = this.getBus();
        BusFactory.setDefaultBus((Bus)bus);
        JaxWsServerFactoryBean factory = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)new QuarkusJaxWsServiceFactoryBean(cxfServletInfos.getWrappersclasses()));
        factory.setBus(bus);
        if (cxfServletInfos.getInfos() == null) {
            return;
        }
        for (CXFServletInfo servletInfo : cxfServletInfos.getInfos()) {
            Object instanceService = this.getInstance(servletInfo.getClassName());
            if (instanceService != null) {
                Interceptor interceptor;
                Class<?> seiClass = null;
                if (servletInfo.getSei() != null) {
                    seiClass = this.loadClass(servletInfo.getSei());
                    factory.setServiceClass(seiClass);
                }
                if (seiClass == null) {
                    LOGGER.warn((Object)("sei not found: " + servletInfo.getSei()));
                }
                factory.setAddress(servletInfo.getPath());
                factory.setServiceBean(instanceService);
                if (servletInfo.getWsdlPath() != null) {
                    factory.setWsdlLocation(servletInfo.getWsdlPath());
                }
                if (servletInfo.getFeatures().size() > 0) {
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    for (String feature : servletInfo.getFeatures()) {
                        Feature instanceFeature = (Feature)this.getInstance(feature);
                        features.add(instanceFeature);
                    }
                    factory.setFeatures(features);
                }
                if (servletInfo.getSOAPBinding() != null) {
                    factory.setBindingId(servletInfo.getSOAPBinding());
                }
                Server server = factory.create();
                for (String className : servletInfo.getInFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getInInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutInterceptors().add(interceptor);
                }
                LOGGER.info((Object)(servletInfo.toString() + " available."));
                continue;
            }
            LOGGER.error((Object)("Cannot initialize " + servletInfo.toString()));
        }
    }
}

