/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFQuarkusServlet;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.core.ManagedServlet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.jws.WebService;
import javax.servlet.ServletException;
import org.jboss.logging.Logger;

@Recorder
public class CXFRecorder {
    private static final Logger LOGGER = Logger.getLogger(CXFRecorder.class);

    public Supplier<CXFClientInfo> cxfClientInfoSupplier(final String sei, final CxfConfig cxfConfig, final String soapBinding, final String wsNamespace, final String wsName, final List<String> classNames) {
        LOGGER.warn((Object)"recorder CXFClientInfoSupplier");
        return new Supplier<CXFClientInfo>(){

            @Override
            public CXFClientInfo get() {
                for (Map.Entry<String, CxfEndpointConfig> webServicesByPath : cxfConfig.endpoints.entrySet()) {
                    String cfgSei;
                    CxfEndpointConfig cxfEndPointConfig = webServicesByPath.getValue();
                    String relativePath = webServicesByPath.getKey();
                    if (!cxfEndPointConfig.serviceInterface.isPresent() || !(cfgSei = cxfEndPointConfig.serviceInterface.get()).equals(sei)) continue;
                    String endpointAddress = cxfEndPointConfig.clientEndpointUrl.orElse("http://localhost:8080");
                    if (!relativePath.equals("/") && !relativePath.equals("")) {
                        endpointAddress = endpointAddress.endsWith("/") ? endpointAddress.substring(0, endpointAddress.length() - 1) : endpointAddress;
                        endpointAddress = relativePath.startsWith("/") ? endpointAddress + relativePath : endpointAddress + "/" + relativePath;
                    }
                    CXFClientInfo cfg = new CXFClientInfo(sei, endpointAddress, cxfEndPointConfig.wsdlPath.orElse(null), soapBinding, wsNamespace, wsName, cxfEndPointConfig.endpointNamespace.orElse(null), cxfEndPointConfig.endpointName.orElse(null), cxfEndPointConfig.username.orElse(null), cxfEndPointConfig.password.orElse(null), classNames);
                    if (cxfEndPointConfig.inInterceptors.isPresent()) {
                        cfg.getInInterceptors().addAll((Collection<String>)cxfEndPointConfig.inInterceptors.get());
                    }
                    if (cxfEndPointConfig.outInterceptors.isPresent()) {
                        cfg.getOutInterceptors().addAll((Collection<String>)cxfEndPointConfig.outInterceptors.get());
                    }
                    if (cxfEndPointConfig.outFaultInterceptors.isPresent()) {
                        cfg.getOutFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors.get());
                    }
                    if (cxfEndPointConfig.inFaultInterceptors.isPresent()) {
                        cfg.getInFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors.get());
                    }
                    if (cxfEndPointConfig.features.isPresent()) {
                        cfg.getFeatures().addAll((Collection<String>)cxfEndPointConfig.features.get());
                    }
                    return cfg;
                }
                LOGGER.warn((Object)("the service interface config is not found for : " + sei));
                return null;
            }
        };
    }

    public void registerCXFServlet(RuntimeValue<CXFServletInfos> runtimeInfos, String sei, CxfConfig cxfConfig, String soapBinding, List<String> wrapperClassNames) {
        CXFServletInfos infos = (CXFServletInfos)runtimeInfos.getValue();
        for (Map.Entry<String, CxfEndpointConfig> webServicesByPath : cxfConfig.endpoints.entrySet()) {
            Class<?>[] interfaces;
            CxfEndpointConfig cxfEndPointConfig = webServicesByPath.getValue();
            String relativePath = webServicesByPath.getKey();
            String serviceInterface = null;
            if (!cxfEndPointConfig.implementor.isPresent()) continue;
            Class<?> webServiceImplementor = null;
            try {
                webServiceImplementor = Class.forName(cxfEndPointConfig.implementor.get());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (webServiceImplementor == null) continue;
            for (Class<?> seiClass : interfaces = webServiceImplementor.getInterfaces()) {
                WebService wsAnnotation = seiClass.getAnnotation(WebService.class);
                if (wsAnnotation == null) continue;
                serviceInterface = seiClass.getName();
            }
            if (!sei.equals(serviceInterface)) continue;
            CXFServletInfo cfg = new CXFServletInfo(relativePath, cxfEndPointConfig.implementor.get(), sei, cxfEndPointConfig.wsdlPath.orElse(null), soapBinding, wrapperClassNames);
            if (cxfEndPointConfig.inInterceptors.isPresent()) {
                cfg.getInInterceptors().addAll((Collection<String>)cxfEndPointConfig.inInterceptors.get());
            }
            if (cxfEndPointConfig.outInterceptors.isPresent()) {
                cfg.getOutInterceptors().addAll((Collection<String>)cxfEndPointConfig.outInterceptors.get());
            }
            if (cxfEndPointConfig.outFaultInterceptors.isPresent()) {
                cfg.getOutFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors.get());
            }
            if (cxfEndPointConfig.inFaultInterceptors.isPresent()) {
                cfg.getInFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors.get());
            }
            if (cxfEndPointConfig.features.isPresent()) {
                cfg.getFeatures().addAll((Collection<String>)cxfEndPointConfig.features.get());
            }
            LOGGER.info((Object)"register CXF Servlet info");
            infos.add(cfg);
        }
    }

    public RuntimeValue<CXFServletInfos> createInfos() {
        CXFServletInfos infos = new CXFServletInfos();
        return new RuntimeValue((Object)infos);
    }

    public void initServlet(DeploymentManager deploymentMgr, RuntimeValue<CXFServletInfos> infos) {
        ManagedServlet managedServlet = deploymentMgr.getDeployment().getServlets().getManagedServlet("org.apache.cxf.transport.servlet.CXFNonSpringServlet");
        try {
            if (managedServlet != null) {
                CXFQuarkusServlet servlet = (CXFQuarkusServlet)((Object)managedServlet.getServlet().getInstance());
                servlet.build((CXFServletInfos)infos.getValue());
            }
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }
}

