/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.QuarkusClientFactoryBean;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.xml.namespace.QName;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.jboss.logging.Logger;

@ApplicationScoped
public class CxfClientProducer {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProducer.class);

    public CXFClientInfo getInfo() {
        return null;
    }

    public Object loadCxfClient() {
        Class<?> seiClass;
        CXFClientInfo cxfClientInfo = this.getInfo();
        try {
            seiClass = Class.forName(cxfClientInfo.getSei(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"either webservice interface (client) or implementation (server) is mandatory");
            return null;
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean((ClientFactoryBean)new QuarkusClientFactoryBean(cxfClientInfo.getClassNames()));
        factory.setServiceClass(seiClass);
        factory.setServiceName(new QName(cxfClientInfo.getWsNamespace(), cxfClientInfo.getWsName()));
        if (cxfClientInfo.getEpName() != null) {
            factory.setEndpointName(new QName(cxfClientInfo.getEpNamespace(), cxfClientInfo.getEpName()));
        }
        factory.setAddress(cxfClientInfo.getEndpointAddress());
        if (cxfClientInfo.getSoapBinding() != null) {
            factory.setBindingId(cxfClientInfo.getSoapBinding());
        }
        if (cxfClientInfo.getWsdlUrl() != null && !cxfClientInfo.getWsdlUrl().isEmpty()) {
            factory.setWsdlURL(cxfClientInfo.getWsdlUrl());
        }
        if (cxfClientInfo.getUsername() != null) {
            factory.setUsername(cxfClientInfo.getUsername());
        }
        if (cxfClientInfo.getPassword() != null) {
            factory.setPassword(cxfClientInfo.getPassword());
        }
        for (String feature : cxfClientInfo.getFeatures()) {
            this.addToCols(feature, factory.getFeatures());
        }
        for (String inInterceptor : cxfClientInfo.getInInterceptors()) {
            this.addToCols(inInterceptor, factory.getInInterceptors());
        }
        for (String outInterceptor : cxfClientInfo.getOutInterceptors()) {
            this.addToCols(outInterceptor, factory.getOutInterceptors());
        }
        for (String outFaultInterceptor : cxfClientInfo.getOutFaultInterceptors()) {
            this.addToCols(outFaultInterceptor, factory.getOutFaultInterceptors());
        }
        for (String inFaultInterceptor : cxfClientInfo.getInFaultInterceptors()) {
            this.addToCols(inFaultInterceptor, factory.getInFaultInterceptors());
        }
        LOGGER.info((Object)("cxf client loaded for " + cxfClientInfo.getSei()));
        return factory.create();
    }

    private <T> void addToCols(String className, List<T> cols) {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Object item = null;
        try {
            Object o;
            item = o = CDI.current().select(cls, new Annotation[0]).get();
            if (item != null) {
                cols.add(item);
            }
        }
        catch (ClassCastException o) {
            // empty catch block
        }
        if (item != null) {
            return;
        }
        try {
            item = o = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (item != null) {
                cols.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

