/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;

public class QuarkusJaxWsServiceFactoryBean
extends JaxWsServiceFactoryBean {
    private static final org.jboss.logging.Logger LOGGER = org.jboss.logging.Logger.getLogger(QuarkusJaxWsServiceFactoryBean.class);
    private Set<Class<?>> wrapperClasses;
    private static final Logger LOG = LogUtils.getLogger(QuarkusJaxWsServiceFactoryBean.class);

    public QuarkusJaxWsServiceFactoryBean(List<String> classeNames) {
        this.wrapperClasses = classeNames.stream().distinct().map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)"Generated Wrapper class not found", (Throwable)e);
                return null;
            }
        }).filter(c -> c != null).collect(Collectors.toSet());
    }

    public void reset() {
        super.reset();
        this.wrapperClasses = null;
    }

    protected Set<Class<?>> getExtraClass() {
        XmlSeeAlso xmlSeeAlsoAnno;
        HashSet classes = new HashSet();
        if (this.wrapperClasses != null) {
            classes.addAll(this.wrapperClasses);
        }
        if ((xmlSeeAlsoAnno = this.getServiceClass().getAnnotation(XmlSeeAlso.class)) != null && xmlSeeAlsoAnno.value() != null) {
            for (int i = 0; i < xmlSeeAlsoAnno.value().length; ++i) {
                Class value = xmlSeeAlsoAnno.value()[i];
                if (value == null) {
                    LOG.log(Level.WARNING, "XMLSEEALSO_NULL_CLASS", new Object[]{this.getServiceClass().getName(), i});
                    continue;
                }
                classes.add(value);
            }
        }
        return classes;
    }
}

