/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.cxf.databinding.WrapperHelper;

@TargetClass(className="org.apache.cxf.jaxb.JAXBDataBinding")
final class Target_org_apache_cxf_jaxb_JAXBDataBinding {
    @Alias
    private static Logger LOG = null;

    Target_org_apache_cxf_jaxb_JAXBDataBinding() {
    }

    @Substitute
    private static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        LOG.info("compileWrapperHelper substitution");
        int count = 1;
        String newClassName = wrapperType.getName() + "_WrapperTypeHelper" + count;
        if (!newClassName.contains("jaxws_asm")) {
            newClassName = newClassName.substring(0, newClassName.lastIndexOf(".")) + ".jaxws_asm" + newClassName.substring(newClassName.lastIndexOf("."));
        }
        Class<?> cls = null;
        try {
            cls = Thread.currentThread().getContextClassLoader().loadClass(newClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Wrapper helper class not found : " + e.toString());
        }
        WrapperHelper helper = null;
        try {
            if (cls != null) {
                helper = (WrapperHelper)WrapperHelper.class.cast(cls.getConstructor(new Class[0]).newInstance(new Object[0]));
                return helper;
            }
        }
        catch (Exception e) {
            LOG.warning("Wrapper helper class not created : " + e.toString());
        }
        throw new UnsupportedOperationException(cls.getName() + " wrapperHelper not implemented yet for GraalVM native images");
    }
}

