/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.devconsole.DevCxfServerInfosSupplier;
import io.quarkiverse.cxf.transport.CxfHandler;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@Recorder
public class CXFRecorder {
    private static final Logger LOGGER = Logger.getLogger(CXFRecorder.class);
    private static final String DEFAULT_EP_ADDR = "http://localhost:8080";

    public RuntimeValue<CXFClientInfo> cxfClientInfoSupplier(CXFClientData cxfClientData) {
        return new RuntimeValue((Object)new CXFClientInfo(cxfClientData.getSei(), String.format("%s/%s", DEFAULT_EP_ADDR, cxfClientData.getSei().toLowerCase()), cxfClientData.getSoapBinding(), cxfClientData.getWsNamespace(), cxfClientData.getWsName(), cxfClientData.getClassNames()));
    }

    /*
     * WARNING - void declaration
     */
    public void registerCXFServlet(RuntimeValue<CXFServletInfos> runtimeInfos, String path, String sei, CxfConfig cxfConfig, String soapBinding, List<String> wrapperClassNames, String wsImplementor, Boolean isProvider) {
        CXFServletInfos infos = (CXFServletInfos)runtimeInfos.getValue();
        HashMap implementorToCfg = new HashMap();
        for (Map.Entry<String, CxfEndpointConfig> entry : cxfConfig.endpoints.entrySet()) {
            List<ServletConfig> lst;
            CxfEndpointConfig cxfEndPointConfig = entry.getValue();
            String relativePath = entry.getKey();
            if (!cxfEndPointConfig.implementor.isPresent()) continue;
            String cfgImplementor = cxfEndPointConfig.implementor.get();
            if (implementorToCfg.containsKey(cfgImplementor)) {
                lst = (List)implementorToCfg.get(cfgImplementor);
            } else {
                lst = new ArrayList();
                implementorToCfg.put(cfgImplementor, lst);
            }
            lst.add(new ServletConfig(cxfEndPointConfig, relativePath));
        }
        List cfgs = (List)implementorToCfg.get(wsImplementor);
        if (cfgs != null) {
            for (ServletConfig cfg : cfgs) {
                CxfEndpointConfig cxfEndPointConfig = cfg.config;
                String relativePath = cfg.path;
                this.startRoute(path, sei, soapBinding, wrapperClassNames, wsImplementor, infos, cxfEndPointConfig, relativePath, isProvider);
            }
        } else {
            void var12_16;
            String string = sei.toLowerCase();
            if (string.contains(".")) {
                String string2 = string.substring(string.lastIndexOf(46) + 1);
            }
            String relativePath = "/" + (String)var12_16;
            this.startRoute(path, sei, soapBinding, wrapperClassNames, wsImplementor, infos, null, relativePath, isProvider);
        }
    }

    private void startRoute(String path, String sei, String soapBinding, List<String> wrapperClassNames, String wsImplementor, CXFServletInfos infos, CxfEndpointConfig cxfEndPointConfig, String relativePath, Boolean isProvider) {
        if (wsImplementor != null && !wsImplementor.equals("")) {
            CXFServletInfo cfg = new CXFServletInfo(path, relativePath, wsImplementor, sei, cxfEndPointConfig != null ? (String)cxfEndPointConfig.wsdlPath.orElse(null) : null, cxfEndPointConfig != null ? cxfEndPointConfig.soapBinding.orElse(soapBinding) : soapBinding, wrapperClassNames, isProvider, cxfEndPointConfig != null ? (String)cxfEndPointConfig.publishedEndpointUrl.orElse(null) : null);
            if (cxfEndPointConfig != null && cxfEndPointConfig.inInterceptors.isPresent()) {
                cfg.getInInterceptors().addAll((Collection<String>)cxfEndPointConfig.inInterceptors.get());
            }
            if (cxfEndPointConfig != null && cxfEndPointConfig.outInterceptors.isPresent()) {
                cfg.getOutInterceptors().addAll((Collection<String>)cxfEndPointConfig.outInterceptors.get());
            }
            if (cxfEndPointConfig != null && cxfEndPointConfig.outFaultInterceptors.isPresent()) {
                cfg.getOutFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors.get());
            }
            if (cxfEndPointConfig != null && cxfEndPointConfig.inFaultInterceptors.isPresent()) {
                cfg.getInFaultInterceptors().addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors.get());
            }
            if (cxfEndPointConfig != null && cxfEndPointConfig.features.isPresent()) {
                cfg.getFeatures().addAll((Collection<String>)cxfEndPointConfig.features.get());
            }
            if (cxfEndPointConfig != null && cxfEndPointConfig.handlers.isPresent()) {
                cfg.getHandlers().addAll((Collection<String>)cxfEndPointConfig.handlers.get());
            }
            LOGGER.trace((Object)"register CXF Servlet info");
            infos.add(cfg);
        }
    }

    public RuntimeValue<CXFServletInfos> createInfos() {
        CXFServletInfos infos = new CXFServletInfos();
        return new RuntimeValue((Object)infos);
    }

    public Handler<RoutingContext> initServer(RuntimeValue<CXFServletInfos> infos, BeanContainer beanContainer, HttpConfiguration httpConfiguration) {
        LOGGER.trace((Object)"init server");
        DevCxfServerInfosSupplier.setServletInfos((CXFServletInfos)infos.getValue());
        return new CxfHandler((CXFServletInfos)infos.getValue(), beanContainer, httpConfiguration);
    }

    public void setPath(RuntimeValue<CXFServletInfos> infos, String path, String contextPath) {
        ((CXFServletInfos)infos.getValue()).setPath(path);
        ((CXFServletInfos)infos.getValue()).setContextPath(contextPath);
    }

    private class ServletConfig {
        public CxfEndpointConfig config;
        public String path;

        public ServletConfig(CxfEndpointConfig cxfEndPointConfig, String relativePath) {
            this.config = cxfEndPointConfig;
            this.path = relativePath;
        }
    }
}

