/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.QuarkusJaxWsServiceFactoryBean;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkiverse.cxf.transport.VertxDestinationRegistryFactory;
import io.quarkiverse.cxf.transport.VertxHttpServletRequest;
import io.quarkiverse.cxf.transport.VertxHttpServletRequestXForwardedFilter;
import io.quarkiverse.cxf.transport.VertxHttpServletResponse;
import io.quarkiverse.cxf.transport.VertxServletConfig;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.jboss.logging.Logger;

public class CxfHandler
implements io.vertx.core.Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(CxfHandler.class);
    private Bus bus;
    private ClassLoader loader;
    private DestinationRegistry destinationRegistry;
    private String contextPath;
    private String servletPath;
    private ServletController controller;
    private BeanContainer beanContainer;
    private CurrentIdentityAssociation association;
    private IdentityProviderManager identityProviderManager;
    private CurrentVertxRequest currentVertxRequest;
    private HttpConfiguration httpConfiguration;
    private static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";

    public CxfHandler(CXFServletInfos cxfServletInfos, BeanContainer beanContainer, HttpConfiguration httpConfiguration) {
        LOGGER.trace((Object)"CxfHandler created");
        this.beanContainer = beanContainer;
        this.httpConfiguration = httpConfiguration;
        Instance identityAssociationInstance = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = identityAssociationInstance.isResolvable() ? (CurrentIdentityAssociation)identityAssociationInstance.get() : null;
        Instance identityProviderManagerInstance = CDI.current().select(IdentityProviderManager.class, new Annotation[0]);
        this.identityProviderManager = identityProviderManagerInstance.isResolvable() ? (IdentityProviderManager)identityProviderManagerInstance.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        if (cxfServletInfos == null || cxfServletInfos.getInfos() == null || cxfServletInfos.getInfos().isEmpty()) {
            LOGGER.warn((Object)"no info transmitted to servlet");
            return;
        }
        this.bus = BusFactory.getDefaultBus();
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        LOGGER.trace((Object)"load destination");
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        this.destinationRegistry = VertxDestinationRegistryFactory.getDestinationRegistry();
        VertxDestinationFactory destinationFactory = new VertxDestinationFactory(this.destinationRegistry);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/quarkus", (DestinationFactory)destinationFactory);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/quarkus", (ConduitInitiator)destinationFactory);
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        VertxServletConfig servletConfig = new VertxServletConfig();
        serviceListGeneratorServlet.init((ServletConfig)servletConfig);
        this.controller = new ServletController(this.destinationRegistry, (ServletConfig)servletConfig, (HttpServlet)serviceListGeneratorServlet);
        this.servletPath = cxfServletInfos.getPath();
        this.contextPath = cxfServletInfos.getContextPath();
        for (CXFServletInfo servletInfo : cxfServletInfos.getInfos()) {
            QuarkusJaxWsServiceFactoryBean jaxWsServiceFactoryBean = new QuarkusJaxWsServiceFactoryBean(cxfServletInfos.getWrappersclasses());
            JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)jaxWsServiceFactoryBean);
            jaxWsServerFactoryBean.setDestinationFactory((DestinationFactory)destinationFactory);
            jaxWsServerFactoryBean.setBus(this.bus);
            Object instanceService = this.getInstance(servletInfo.getClassName());
            if (instanceService != null) {
                Interceptor interceptor;
                if (servletInfo.isProvider().booleanValue()) {
                    jaxWsServiceFactoryBean.setInvoker((Invoker)new JAXWSMethodInvoker(instanceService));
                }
                jaxWsServerFactoryBean.setServiceName(new QName(servletInfo.getServiceTargetNamespace(), servletInfo.getServiceName()));
                jaxWsServerFactoryBean.setServiceClass(instanceService.getClass());
                jaxWsServerFactoryBean.setAddress(servletInfo.getRelativePath());
                jaxWsServerFactoryBean.setServiceBean(instanceService);
                if (servletInfo.getWsdlPath() != null) {
                    jaxWsServerFactoryBean.setWsdlLocation(servletInfo.getWsdlPath());
                }
                if (!servletInfo.getFeatures().isEmpty()) {
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    for (String feature : servletInfo.getFeatures()) {
                        Feature instanceFeature = (Feature)this.getInstance(feature);
                        features.add(instanceFeature);
                    }
                    jaxWsServerFactoryBean.setFeatures(features);
                }
                if (!servletInfo.getHandlers().isEmpty()) {
                    ArrayList<Handler> handlers = new ArrayList<Handler>();
                    for (String handler : servletInfo.getHandlers()) {
                        Handler instanceHandler = (Handler)this.getInstance(handler);
                        handlers.add(instanceHandler);
                    }
                    jaxWsServerFactoryBean.setHandlers(handlers);
                }
                if (servletInfo.getSOAPBinding() != null) {
                    jaxWsServerFactoryBean.setBindingId(servletInfo.getSOAPBinding());
                }
                if (servletInfo.getEndpointUrl() != null) {
                    jaxWsServerFactoryBean.setPublishedEndpointUrl(servletInfo.getEndpointUrl());
                }
                Server server = jaxWsServerFactoryBean.create();
                for (String className : servletInfo.getInFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getInInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getInInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutFaultInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutInterceptors()) {
                    interceptor = (Interceptor)this.getInstance(className);
                    server.getEndpoint().getOutInterceptors().add(interceptor);
                }
                LOGGER.info((Object)(servletInfo.toString() + " available."));
                continue;
            }
            LOGGER.error((Object)("Cannot initialize " + servletInfo.toString()));
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("failed to load class " + className));
                return null;
            }
        }
    }

    private Object getInstance(String className) {
        Class<?> classObj = this.loadClass(className);
        if (classObj != null) {
            try {
                return CDI.current().select(classObj, new Annotation[0]).get();
            }
            catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                try {
                    return classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ClassLoaderUtils.ClassLoaderHolder origLoader;
        block7: {
            origLoader = null;
            Bus origBus = null;
            try {
                if (this.loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                }
                if (this.bus != null) {
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                }
                this.process(event);
                if (origBus == this.bus) break block7;
            }
            catch (Throwable throwable) {
                if (origBus != this.bus) {
                    BusFactory.setThreadDefaultBus(origBus);
                }
                if (origLoader != null) {
                    origLoader.reset();
                }
                throw throwable;
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
        if (origLoader != null) {
            origLoader.reset();
        }
    }

    private HttpServletRequest checkXForwardedHeaders(HttpServletRequest request) {
        String originalPort;
        String originalHost;
        String originalPrefix;
        String originalRemoteAddr;
        String originalProtocol;
        if (this.httpConfiguration.proxy.proxyAddressForwarding && Stream.of(originalProtocol = request.getHeader(X_FORWARDED_PROTO_HEADER), originalRemoteAddr = request.getHeader(X_FORWARDED_FOR_HEADER), originalPrefix = this.httpConfiguration.proxy.enableForwardedPrefix ? null : request.getHeader(this.httpConfiguration.proxy.forwardedPrefixHeader), originalHost = this.httpConfiguration.proxy.enableForwardedHost ? null : request.getHeader(this.httpConfiguration.proxy.forwardedHostHeader), originalPort = request.getHeader(X_FORWARDED_PORT_HEADER)).anyMatch(Objects::nonNull)) {
            return new VertxHttpServletRequestXForwardedFilter(request, originalProtocol, originalRemoteAddr, originalPrefix, originalHost, originalPort);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RoutingContext event) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, (IdentityProviderManager)this.identityProviderManager));
            }
        }
        this.currentVertxRequest.setCurrent(event);
        try {
            VertxHttpServletRequest req = new VertxHttpServletRequest(event, this.contextPath, this.servletPath);
            VertxHttpServletResponse resp = new VertxHttpServletResponse(event);
            req = this.checkXForwardedHeaders(req);
            this.controller.invoke((HttpServletRequest)req, (HttpServletResponse)resp);
            resp.end();
        }
        catch (ServletException se) {
            LOGGER.warn((Object)"Internal server error", (Throwable)se);
            event.fail(500, (Throwable)se);
        }
        catch (RuntimeException re) {
            LOGGER.warn((Object)"Cannot list or instantiate web service", (Throwable)re);
            event.fail(404, (Throwable)re);
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }
}

