/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.transport.VertxDestination;
import io.quarkiverse.cxf.transport.VertxDestinationRegistryFactory;
import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.jboss.logging.Logger;

public class VertxDestinationFactory
extends SoapTransportFactory
implements DestinationFactory {
    private static final Logger LOGGER = Logger.getLogger(VertxDestinationFactory.class);
    protected final DestinationRegistry registry;

    public VertxDestinationFactory() {
        this(VertxDestinationRegistryFactory.getDestinationRegistry());
    }

    protected VertxDestinationFactory(DestinationRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        if (endpointInfo == null) {
            throw new IllegalArgumentException("EndpointInfo cannot be null");
        }
        DestinationRegistry destinationRegistry = this.registry;
        synchronized (destinationRegistry) {
            String endpointAddress = endpointInfo.getAddress();
            LOGGER.debug((Object)String.format("Looking for destination for address %s...", endpointAddress));
            Object d = this.registry.getDestinationForPath(endpointInfo.getAddress());
            if (d == null) {
                LOGGER.debug((Object)String.format("Creating VertxDestination for address %s...", endpointAddress));
                d = new VertxDestination(endpointInfo, bus, this.registry);
                this.registry.addDestination(d);
                d.finalizeConfig();
            }
            LOGGER.debug((Object)String.format("Destination for address %s is %s", endpointAddress, d));
            return d;
        }
    }
}

