/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.devconsole.DevCxfServerInfosSupplier;
import io.quarkiverse.cxf.transport.CxfHandler;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@Recorder
public class CXFRecorder {
    private static final Logger LOGGER = Logger.getLogger(CXFRecorder.class);
    private static final String DEFAULT_EP_ADDR = "http://localhost:8080";

    public RuntimeValue<CXFClientInfo> cxfClientInfoSupplier(CXFClientData cxfClientData) {
        return new RuntimeValue((Object)new CXFClientInfo(cxfClientData.getSei(), String.format("%s/%s", DEFAULT_EP_ADDR, cxfClientData.getSei().toLowerCase()), cxfClientData.getSoapBinding(), cxfClientData.getWsNamespace(), cxfClientData.getWsName(), cxfClientData.getClassNames()));
    }

    public void addCxfServletInfo(RuntimeValue<CXFServletInfos> runtimeInfos, String path, String sei, CxfConfig cxfConfig, String serviceName, String serviceTargetNamepsace, String soapBinding, List<String> wrapperClassNames, String wsImplementor, Boolean isProvider) {
        CXFServletInfos infos = (CXFServletInfos)runtimeInfos.getValue();
        HashMap implementorToCfg = new HashMap();
        for (Map.Entry<String, CxfEndpointConfig> entry : cxfConfig.endpoints.entrySet()) {
            List<ServletConfig> lst;
            CxfEndpointConfig cxfEndPointConfig = entry.getValue();
            String relativePath = entry.getKey();
            if (!cxfEndPointConfig.implementor.isPresent()) continue;
            String cfgImplementor = cxfEndPointConfig.implementor.get();
            if (implementorToCfg.containsKey(cfgImplementor)) {
                lst = (List)implementorToCfg.get(cfgImplementor);
            } else {
                lst = new ArrayList();
                implementorToCfg.put(cfgImplementor, lst);
            }
            lst.add(new ServletConfig(cxfEndPointConfig, relativePath));
        }
        List cfgs = (List)implementorToCfg.get(wsImplementor);
        if (cfgs != null) {
            for (ServletConfig cfg : cfgs) {
                CxfEndpointConfig cxfEndPointConfig = cfg.config;
                String relativePath = cfg.path;
                CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wrapperClassNames, wsImplementor, cxfEndPointConfig, relativePath, isProvider);
                infos.add(info);
            }
        } else {
            if ((serviceName == null || serviceName.isEmpty()) && (serviceName = sei.toLowerCase()).contains(".")) {
                serviceName = serviceName.substring(serviceName.lastIndexOf(46) + 1);
            }
            String string = "/" + serviceName;
            CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wrapperClassNames, wsImplementor, null, string, isProvider);
            infos.add(info);
        }
    }

    private static CXFServletInfo createServletInfo(String path, String sei, String serviceName, String serviceTargetNamespace, String soapBinding, List<String> wrapperClassNames, String wsImplementor, CxfEndpointConfig cxfEndPointConfig, String relativePath, Boolean isProvider) {
        CXFServletInfo cfg = new CXFServletInfo(path, relativePath, wsImplementor, sei, cxfEndPointConfig != null ? (String)cxfEndPointConfig.wsdlPath.orElse(null) : null, serviceName, serviceTargetNamespace, cxfEndPointConfig != null ? cxfEndPointConfig.soapBinding.orElse(soapBinding) : soapBinding, wrapperClassNames, isProvider, cxfEndPointConfig != null ? (String)cxfEndPointConfig.publishedEndpointUrl.orElse(null) : null);
        if (cxfEndPointConfig != null && cxfEndPointConfig.inInterceptors.isPresent()) {
            cfg.addInInterceptors(cxfEndPointConfig.inInterceptors.get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.outInterceptors.isPresent()) {
            cfg.addOutInterceptors(cxfEndPointConfig.outInterceptors.get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.outFaultInterceptors.isPresent()) {
            cfg.addOutFaultInterceptors(cxfEndPointConfig.outFaultInterceptors.get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.inFaultInterceptors.isPresent()) {
            cfg.addInFaultInterceptors(cxfEndPointConfig.inFaultInterceptors.get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.features.isPresent()) {
            cfg.addFeatures(cxfEndPointConfig.features.get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.handlers.isPresent()) {
            cfg.addHandlers(cxfEndPointConfig.handlers.get());
        }
        LOGGER.tracef("Registering CXF Servlet info %s", (Object)cfg);
        return cfg;
    }

    public RuntimeValue<CXFServletInfos> createInfos(String path, String contextPath) {
        CXFServletInfos infos = new CXFServletInfos(path, contextPath);
        return new RuntimeValue((Object)infos);
    }

    public Handler<RoutingContext> initServer(RuntimeValue<CXFServletInfos> infos, BeanContainer beanContainer, HttpConfiguration httpConfiguration) {
        LOGGER.trace((Object)"init server");
        DevCxfServerInfosSupplier.setServletInfos((CXFServletInfos)infos.getValue());
        return new CxfHandler((CXFServletInfos)infos.getValue(), beanContainer, httpConfiguration);
    }

    public void resetDestinationRegistry(ShutdownContext context) {
        context.addShutdownTask(VertxDestinationFactory::resetRegistry);
    }

    private static class ServletConfig {
        public CxfEndpointConfig config;
        public String path;

        public ServletConfig(CxfEndpointConfig cxfEndPointConfig, String relativePath) {
            this.config = cxfEndPointConfig;
            this.path = relativePath;
        }
    }
}

