/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.QuarkusRuntimeJaxWsServiceFactoryBean;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkiverse.cxf.transport.VertxHttpServletRequest;
import io.quarkiverse.cxf.transport.VertxHttpServletRequestXForwardedFilter;
import io.quarkiverse.cxf.transport.VertxHttpServletResponse;
import io.quarkiverse.cxf.transport.VertxServletConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.handler.Handler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.jboss.logging.Logger;

public class CxfHandler
implements io.vertx.core.Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(CxfHandler.class);
    private final Bus bus;
    private final ClassLoader loader;
    private final String contextPath;
    private final String servletPath;
    private final ServletController controller;
    private final BeanContainer beanContainer;
    private final CurrentIdentityAssociation association;
    private final IdentityProviderManager identityProviderManager;
    private final CurrentVertxRequest currentVertxRequest;
    private final HttpConfiguration httpConfiguration;
    private static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";

    public CxfHandler(CXFServletInfos cxfServletInfos, BeanContainer beanContainer, HttpConfiguration httpConfiguration) {
        LOGGER.trace((Object)"CxfHandler created");
        this.beanContainer = beanContainer;
        this.httpConfiguration = httpConfiguration;
        Instance identityAssociationInstance = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = identityAssociationInstance.isResolvable() ? (CurrentIdentityAssociation)identityAssociationInstance.get() : null;
        Instance identityProviderManagerInstance = CDI.current().select(IdentityProviderManager.class, new Annotation[0]);
        this.identityProviderManager = identityProviderManagerInstance.isResolvable() ? (IdentityProviderManager)identityProviderManagerInstance.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        this.bus = BusFactory.getDefaultBus();
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        LOGGER.trace((Object)"load destination");
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        VertxDestinationFactory destinationFactory = new VertxDestinationFactory();
        DestinationRegistry destinationRegistry = destinationFactory.getDestinationRegistry();
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/quarkus", (DestinationFactory)destinationFactory);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/quarkus", (ConduitInitiator)destinationFactory);
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(destinationRegistry, this.bus);
        VertxServletConfig servletConfig = new VertxServletConfig();
        serviceListGeneratorServlet.init((ServletConfig)servletConfig);
        this.controller = new ServletController(destinationRegistry, (ServletConfig)servletConfig, (HttpServlet)serviceListGeneratorServlet);
        this.servletPath = cxfServletInfos.getPath();
        this.contextPath = cxfServletInfos.getContextPath();
        for (CXFServletInfo servletInfo : cxfServletInfos.getInfos()) {
            QuarkusRuntimeJaxWsServiceFactoryBean jaxWsServiceFactoryBean = new QuarkusRuntimeJaxWsServiceFactoryBean();
            JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)jaxWsServiceFactoryBean);
            jaxWsServerFactoryBean.setDestinationFactory((DestinationFactory)destinationFactory);
            jaxWsServerFactoryBean.setBus(this.bus);
            String endpointType = servletInfo.getClassName();
            Object instanceService = CxfHandler.getInstance(endpointType, false);
            if (instanceService != null) {
                Interceptor interceptor;
                if (servletInfo.isProvider().booleanValue()) {
                    jaxWsServiceFactoryBean.setInvoker((Invoker)new JAXWSMethodInvoker(instanceService));
                }
                jaxWsServerFactoryBean.setServiceName(new QName(servletInfo.getServiceTargetNamespace(), servletInfo.getServiceName()));
                jaxWsServerFactoryBean.setServiceClass(instanceService.getClass());
                jaxWsServerFactoryBean.setAddress(servletInfo.getRelativePath());
                jaxWsServerFactoryBean.setServiceBean(instanceService);
                if (servletInfo.getWsdlPath() != null) {
                    jaxWsServerFactoryBean.setWsdlLocation(servletInfo.getWsdlPath());
                }
                if (!servletInfo.getFeatures().isEmpty()) {
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    for (String feature : servletInfo.getFeatures()) {
                        Feature instanceFeature = (Feature)CxfHandler.getInstance(feature, "feature", endpointType);
                        features.add(instanceFeature);
                    }
                    jaxWsServerFactoryBean.setFeatures(features);
                }
                if (!servletInfo.getHandlers().isEmpty()) {
                    ArrayList<Handler> handlers = new ArrayList<Handler>();
                    for (String handler : servletInfo.getHandlers()) {
                        Handler instanceHandler = (Handler)CxfHandler.getInstance(handler, "handler", endpointType);
                        handlers.add(instanceHandler);
                    }
                    jaxWsServerFactoryBean.setHandlers(handlers);
                }
                if (servletInfo.getSOAPBinding() != null) {
                    jaxWsServerFactoryBean.setBindingId(servletInfo.getSOAPBinding());
                }
                if (servletInfo.getEndpointUrl() != null) {
                    jaxWsServerFactoryBean.setPublishedEndpointUrl(servletInfo.getEndpointUrl());
                }
                Server server = jaxWsServerFactoryBean.create();
                for (String className : servletInfo.getInFaultInterceptors()) {
                    interceptor = (Interceptor)CxfHandler.getInstance(className, "inFaultInterceptor", endpointType);
                    server.getEndpoint().getInFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getInInterceptors()) {
                    interceptor = (Interceptor)CxfHandler.getInstance(className, "inInterceptor", endpointType);
                    server.getEndpoint().getInInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutFaultInterceptors()) {
                    interceptor = (Interceptor)CxfHandler.getInstance(className, "outFaultInterceptor", endpointType);
                    server.getEndpoint().getOutFaultInterceptors().add(interceptor);
                }
                for (String className : servletInfo.getOutInterceptors()) {
                    interceptor = (Interceptor)CxfHandler.getInstance(className, "outInterceptor", endpointType);
                    server.getEndpoint().getOutInterceptors().add(interceptor);
                }
                LOGGER.info((Object)(servletInfo.toString() + " available."));
                continue;
            }
            LOGGER.error((Object)("Cannot initialize " + servletInfo.toString()));
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                e1.addSuppressed(e2);
                throw new RuntimeException("Could not load " + className + " using current thread class loader nor " + CxfHandler.class.getName() + " class loader", e1);
            }
        }
    }

    private static <T> T getInstance(String beanRef, boolean namedBeansSupported) {
        if (namedBeansSupported && beanRef != null && beanRef.startsWith("#")) {
            String beanName = beanRef.substring(1);
            return (T)Arc.container().instance(beanName).get();
        }
        Class<?> classObj = CxfHandler.loadClass(beanRef);
        Objects.requireNonNull(classObj, "Could not load class " + beanRef);
        try {
            return (T)CDI.current().select(classObj, new Annotation[0]).get();
        }
        catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
            try {
                return (T)classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not instantiate " + beanRef + " using the default constructor. Make sure that the constructor exists and that the class is static in case it is an inner class.", e);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw new RuntimeException("Could not instantiate " + beanRef + " using the default constructor.", e);
            }
        }
    }

    private static <T> T getInstance(String className, String kind, String targetType) {
        try {
            return CxfHandler.getInstance(className, true);
        }
        catch (AmbiguousResolutionException e) {
            throw new IllegalStateException("Unable to add a " + kind + " to CXF endpoint " + targetType + ": there are multiple instances of " + className + " available in the CDI container. Either make sure there is only one instance available in the container or create a unique subtype of " + className + " and set that one on " + targetType + " or add @jakarta.inject.Named(\"myName\") to some of the beans and refer to that bean by #myName on " + targetType, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ClassLoaderUtils.ClassLoaderHolder origLoader;
        block7: {
            origLoader = null;
            Bus origBus = null;
            try {
                if (this.loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                }
                if (this.bus != null) {
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                }
                this.process(event);
                if (origBus == this.bus) break block7;
            }
            catch (Throwable throwable) {
                if (origBus != this.bus) {
                    BusFactory.setThreadDefaultBus(origBus);
                }
                if (origLoader != null) {
                    origLoader.reset();
                }
                throw throwable;
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
        if (origLoader != null) {
            origLoader.reset();
        }
    }

    private HttpServletRequest checkXForwardedHeaders(HttpServletRequest request) {
        String originalPort;
        String originalHost;
        String originalPrefix;
        String originalRemoteAddr;
        String originalProtocol;
        if (this.httpConfiguration.proxy.proxyAddressForwarding && Stream.of(originalProtocol = request.getHeader(X_FORWARDED_PROTO_HEADER), originalRemoteAddr = request.getHeader(X_FORWARDED_FOR_HEADER), originalPrefix = this.httpConfiguration.proxy.enableForwardedPrefix ? null : request.getHeader(this.httpConfiguration.proxy.forwardedPrefixHeader), originalHost = this.httpConfiguration.proxy.enableForwardedHost ? null : request.getHeader(this.httpConfiguration.proxy.forwardedHostHeader), originalPort = request.getHeader(X_FORWARDED_PORT_HEADER)).anyMatch(Objects::nonNull)) {
            return new VertxHttpServletRequestXForwardedFilter(request, originalProtocol, originalRemoteAddr, originalPrefix, originalHost, originalPort);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RoutingContext event) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, (IdentityProviderManager)this.identityProviderManager));
            }
        }
        this.currentVertxRequest.setCurrent(event);
        try {
            VertxHttpServletRequest req = new VertxHttpServletRequest(event, this.contextPath, this.servletPath);
            VertxHttpServletResponse resp = new VertxHttpServletResponse(event);
            req = this.checkXForwardedHeaders(req);
            this.controller.invoke((HttpServletRequest)req, (HttpServletResponse)resp);
            resp.end();
        }
        catch (ServletException se) {
            LOGGER.warn((Object)"Internal server error", (Throwable)se);
            event.fail(500, (Throwable)se);
        }
        catch (RuntimeException re) {
            LOGGER.warn((Object)"Cannot list or instantiate web service", (Throwable)re);
            event.fail(404, (Throwable)re);
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }
}

