/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkus.arc.Arc;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class CXFRuntimeUtils {
    public static <T> T getInstance(String beanRef, boolean namedBeansSupported) {
        if (namedBeansSupported && beanRef != null && beanRef.startsWith("#")) {
            String beanName = beanRef.substring(1);
            return (T)Arc.container().instance(beanName).get();
        }
        Class<?> classObj = CXFRuntimeUtils.loadClass(beanRef);
        Objects.requireNonNull(classObj, "Could not load class " + beanRef);
        try {
            return (T)CDI.current().select(classObj, new Annotation[0]).get();
        }
        catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
            try {
                return (T)classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not instantiate " + beanRef + " using the default constructor. Make sure that the constructor exists and that the class is static in case it is an inner class.", e);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw new RuntimeException("Could not instantiate " + beanRef + " using the default constructor.", e);
            }
        }
    }

    public static <T> T getInstance(String className, String kind, String targetType) {
        try {
            return CXFRuntimeUtils.getInstance(className, true);
        }
        catch (AmbiguousResolutionException e) {
            throw new IllegalStateException("Unable to add a " + kind + " to CXF endpoint " + targetType + ": there are multiple instances of " + className + " available in the CDI container. Either make sure there is only one instance available in the container or create a unique subtype of " + className + " and set that one on " + targetType + " or add @jakarta.inject.Named(\"myName\") to some of the beans and refer to that bean by #myName on " + targetType, e);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                e1.addSuppressed(e2);
                throw new RuntimeException("Could not load " + className + " using current thread class loader nor " + CXFRuntimeUtils.class.getName() + " class loader", e1);
            }
        }
    }
}

