/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkus.arc.Unremovable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@Unremovable
public class CXFClientInfo {
    private String sei;
    private String endpointAddress;
    private String wsdlUrl;
    private String soapBinding;
    private String wsNamespace;
    private String wsName;
    private String epNamespace;
    private String epName;
    private String username;
    private String password;
    private boolean proxyClassRuntimeInitialized;
    private List<String> inInterceptors = new ArrayList<String>();
    private List<String> outInterceptors = new ArrayList<String>();
    private List<String> outFaultInterceptors = new ArrayList<String>();
    private List<String> inFaultInterceptors = new ArrayList<String>();
    private List<String> features = new ArrayList<String>();
    private List<String> handlers = new ArrayList<String>();
    private long connectionTimeout;
    private long receiveTimeout;
    private long connectionRequestTimeout;
    private boolean autoRedirect;
    private int maxRetransmits;
    private boolean allowChunking;
    private int chunkingThreshold;
    private int chunkLength;
    private String accept;
    private String acceptLanguage;
    private String acceptEncoding;
    private String contentType;
    private String host;
    private ConnectionType connection;
    private String cacheControl;
    private String version;
    private String browserType;
    private String decoupledEndpoint;
    private String proxyServer;
    private Integer proxyServerPort;
    private String nonProxyHosts;
    private ProxyServerType proxyServerType;
    private String proxyUsername;
    private String proxyPassword;
    private CxfClientConfig.HTTPConduitImpl httpConduitImpl;

    public CXFClientInfo() {
    }

    public CXFClientInfo(String sei, String endpointAddress, String soapBinding, String wsNamespace, String wsName, boolean proxyClassRuntimeInitialized) {
        this.endpointAddress = endpointAddress;
        this.epName = null;
        this.epNamespace = null;
        this.password = null;
        this.sei = sei;
        this.soapBinding = soapBinding;
        this.username = null;
        this.wsName = wsName;
        this.wsNamespace = wsNamespace;
        this.wsdlUrl = null;
        this.proxyClassRuntimeInitialized = proxyClassRuntimeInitialized;
    }

    public CXFClientInfo(CXFClientInfo other) {
        this(other.sei, other.endpointAddress, other.soapBinding, other.wsNamespace, other.wsName, other.proxyClassRuntimeInitialized);
        this.wsdlUrl = other.wsdlUrl;
        this.epNamespace = other.epNamespace;
        this.epName = other.epName;
        this.username = other.username;
        this.password = other.password;
        this.features.addAll(other.features);
        this.handlers.addAll(other.handlers);
        this.inFaultInterceptors.addAll(other.inFaultInterceptors);
        this.inInterceptors.addAll(other.inInterceptors);
        this.outFaultInterceptors.addAll(other.outFaultInterceptors);
        this.outInterceptors.addAll(other.outInterceptors);
        this.connectionTimeout = other.connectionTimeout;
        this.receiveTimeout = other.receiveTimeout;
        this.connectionRequestTimeout = other.connectionRequestTimeout;
        this.autoRedirect = other.autoRedirect;
        this.maxRetransmits = other.maxRetransmits;
        this.allowChunking = other.allowChunking;
        this.chunkingThreshold = other.chunkingThreshold;
        this.chunkLength = other.chunkLength;
        this.accept = other.accept;
        this.acceptLanguage = other.acceptLanguage;
        this.acceptEncoding = other.acceptEncoding;
        this.contentType = other.contentType;
        this.host = other.host;
        this.connection = other.connection;
        this.cacheControl = other.cacheControl;
        this.version = other.version;
        this.browserType = other.browserType;
        this.decoupledEndpoint = other.decoupledEndpoint;
        this.proxyServer = other.proxyServer;
        this.proxyServerPort = other.proxyServerPort;
        this.nonProxyHosts = other.nonProxyHosts;
        this.proxyServerType = other.proxyServerType;
        this.proxyUsername = other.proxyUsername;
        this.proxyPassword = other.proxyPassword;
        this.httpConduitImpl = other.httpConduitImpl;
    }

    public CXFClientInfo withConfig(CxfClientConfig config, String configKey) {
        Objects.requireNonNull(config);
        this.wsdlUrl = config.wsdlPath.orElse(this.wsdlUrl);
        this.epNamespace = config.endpointNamespace.orElse(this.epNamespace);
        this.epName = config.endpointName.orElse(this.epName);
        this.username = config.username.orElse(this.username);
        this.password = config.password.orElse(this.password);
        this.soapBinding = config.soapBinding.orElse(this.soapBinding);
        this.endpointAddress = config.clientEndpointUrl.orElse(this.endpointAddress);
        this.addFeatures(config);
        this.addHandlers(config);
        this.addInterceptors(config);
        this.connectionTimeout = config.connectionTimeout;
        this.receiveTimeout = config.receiveTimeout;
        this.connectionRequestTimeout = config.connectionRequestTimeout;
        this.autoRedirect = config.autoRedirect;
        this.maxRetransmits = config.maxRetransmits;
        this.allowChunking = config.allowChunking;
        this.chunkingThreshold = config.chunkingThreshold;
        this.chunkLength = config.chunkLength;
        this.accept = config.accept.orElse(null);
        this.acceptLanguage = config.acceptLanguage.orElse(null);
        this.acceptEncoding = config.acceptEncoding.orElse(null);
        this.contentType = config.contentType.orElse(null);
        this.host = config.host.orElse(null);
        this.connection = config.connection;
        this.cacheControl = config.cacheControl.orElse(null);
        this.version = config.version;
        this.browserType = config.browserType.orElse(null);
        this.decoupledEndpoint = config.decoupledEndpoint.orElse(null);
        this.proxyServer = config.proxyServer.orElse(null);
        this.proxyServerPort = config.proxyServerPort.orElse(null);
        this.nonProxyHosts = config.nonProxyHosts.orElse(null);
        this.proxyServerType = config.proxyServerType;
        this.proxyUsername = config.proxyUsername.orElse(null);
        this.proxyPassword = config.proxyPassword.orElse(null);
        this.httpConduitImpl = CxfClientConfig.HTTPConduitImpl.fromOptional(config.httpConduitFactory, CXFRecorder.isHc5Present(), "quarkus.cxf.client." + configKey + ".http-conduit-impl");
        return this;
    }

    public String getSei() {
        return this.sei;
    }

    public void setSei(String sei) {
        this.sei = sei;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String getWsNamespace() {
        return this.wsNamespace;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getEpNamespace() {
        return this.epNamespace;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isProxyClassRuntimeInitialized() {
        return this.proxyClassRuntimeInitialized;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public List<String> getInInterceptors() {
        return this.inInterceptors;
    }

    public List<String> getOutInterceptors() {
        return this.outInterceptors;
    }

    public List<String> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public List<String> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    private CXFClientInfo addInterceptors(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.inInterceptors.isPresent()) {
            this.inInterceptors.addAll((Collection<String>)cxfEndPointConfig.inInterceptors.get());
        }
        if (cxfEndPointConfig.outInterceptors.isPresent()) {
            this.outInterceptors.addAll((Collection<String>)cxfEndPointConfig.outInterceptors.get());
        }
        if (cxfEndPointConfig.outFaultInterceptors.isPresent()) {
            this.outFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors.get());
        }
        if (cxfEndPointConfig.inFaultInterceptors.isPresent()) {
            this.inFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors.get());
        }
        return this;
    }

    private CXFClientInfo addFeatures(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.features.isPresent()) {
            this.features.addAll((Collection<String>)cxfEndPointConfig.features.get());
        }
        return this;
    }

    private CXFClientInfo addHandlers(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.handlers.isPresent()) {
            this.handlers.addAll((Collection<String>)cxfEndPointConfig.handlers.get());
        }
        return this;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Long getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    public int getMaxRetransmits() {
        return this.maxRetransmits;
    }

    public boolean isAllowChunking() {
        return this.allowChunking;
    }

    public int getChunkingThreshold() {
        return this.chunkingThreshold;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHost() {
        return this.host;
    }

    public ConnectionType getConnection() {
        return this.connection;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ProxyServerType getProxyServerType() {
        return this.proxyServerType;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public CxfClientConfig.HTTPConduitImpl getHttpConduitImpl() {
        return this.httpConduitImpl;
    }
}

