/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.ConnectionTypeConverter;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConvertWith;
import java.util.List;
import java.util.Optional;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@ConfigGroup
public class CxfClientConfig {
    @ConfigItem(name="wsdl")
    public Optional<String> wsdlPath;
    @ConfigItem
    public Optional<String> soapBinding;
    @ConfigItem
    public Optional<String> clientEndpointUrl;
    @ConfigItem
    public Optional<String> endpointNamespace;
    @ConfigItem
    public Optional<String> endpointName;
    @ConfigItem
    public Optional<String> username;
    @ConfigItem
    public Optional<String> password;
    @ConfigItem
    public Optional<List<String>> features;
    @ConfigItem
    public Optional<List<String>> handlers;
    @ConfigItem
    public Optional<List<String>> inInterceptors;
    @ConfigItem
    public Optional<List<String>> outInterceptors;
    @ConfigItem
    public Optional<List<String>> outFaultInterceptors;
    @ConfigItem
    public Optional<List<String>> inFaultInterceptors;
    @ConfigItem(defaultValue="30000")
    public long connectionTimeout;
    @ConfigItem(defaultValue="60000")
    public long receiveTimeout;
    @ConfigItem(defaultValue="60000")
    public long connectionRequestTimeout;
    @ConfigItem(defaultValue="false")
    public boolean autoRedirect;
    @ConfigItem(defaultValue="-1")
    public int maxRetransmits;
    @ConfigItem(defaultValue="true")
    public boolean allowChunking;
    @ConfigItem(defaultValue="4096")
    public int chunkingThreshold;
    @ConfigItem(defaultValue="-1")
    public int chunkLength;
    @ConfigItem
    public Optional<String> accept;
    @ConfigItem
    public Optional<String> acceptLanguage;
    @ConfigItem
    public Optional<String> acceptEncoding;
    @ConfigItem
    public Optional<String> contentType;
    @ConfigItem
    public Optional<String> host;
    @ConfigItem(defaultValue="Keep-Alive")
    @ConvertWith(value=ConnectionTypeConverter.class)
    public ConnectionType connection;
    @ConfigItem
    public Optional<String> cacheControl;
    @ConfigItem(defaultValue="auto")
    public String version;
    @ConfigItem
    public Optional<String> browserType;
    @ConfigItem
    public Optional<String> decoupledEndpoint;
    @ConfigItem
    public Optional<String> proxyServer;
    @ConfigItem
    public Optional<Integer> proxyServerPort;
    @ConfigItem
    public Optional<String> nonProxyHosts;
    @ConfigItem(defaultValue="HTTP")
    public ProxyServerType proxyServerType;
    @ConfigItem
    public Optional<String> proxyUsername;
    @ConfigItem
    public Optional<String> proxyPassword;
    @ConfigItem
    public Optional<HTTPConduitImpl> httpConduitFactory;

    public static enum HTTPConduitImpl {
        QuarkusCXFDefault,
        CXFDefault,
        HttpClientHTTPConduitFactory,
        URLConnectionHTTPConduitFactory;


        public static HTTPConduitImpl fromOptional(Optional<HTTPConduitImpl> optional, boolean hc5Present, String key, HTTPConduitImpl defaultValue) {
            if (optional.isPresent() && optional.get() != CXFDefault && hc5Present) {
                throw new RuntimeException("You cannot use " + key + "=" + optional.get().name() + " and io.quarkiverse.cxf:quarkus-cxf-rt-transports-http-hc5 simultaneously. Either remove " + key + "=" + optional.get().name() + " from application.properties or remove the io.quarkiverse.cxf:quarkus-cxf-rt-transports-http-hc5 dependency");
            }
            if (!optional.isPresent() && hc5Present) {
                return CXFDefault;
            }
            return optional.orElse(defaultValue);
        }
    }
}

