/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.core.runtime.VertxBufferImpl;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jboss.logging.Logger;

public class VertxServletOutputStream
extends ServletOutputStream {
    private static final Logger log = Logger.getLogger(VertxServletOutputStream.class);
    private final HttpServerRequest request;
    protected HttpServerResponse response;
    private ByteBuf pooledBuffer;
    private boolean committed;
    protected boolean waitingForDrain;
    protected boolean drainHandlerRegistered;
    private boolean closed;
    protected boolean first = true;
    protected Throwable throwable;
    private ByteArrayOutputStream overflow;
    private Object LOCK = new Object();

    public VertxServletOutputStream(HttpServerRequest request, HttpServerResponse response) {
        this.response = response;
        this.request = request;
        request.response().exceptionHandler(event -> {
            this.throwable = event;
            log.debugf(event, "IO Exception ", new Object[0]);
            request.connection().close();
            Object object = this.LOCK;
            synchronized (object) {
                if (this.waitingForDrain) {
                    this.LOCK.notifyAll();
                }
            }
        });
        request.response().endHandler(unused -> {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.waitingForDrain) {
                    this.LOCK.notifyAll();
                }
            }
        });
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
            }
            while (rem > 0) {
                int toWrite = Math.min(rem, buffer.writableBytes());
                buffer.writeBytes(b, idx, toWrite);
                rem -= toWrite;
                idx += toWrite;
                if (buffer.isWritable()) continue;
                ByteBuf tmpBuf = buffer;
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
                this.writeBlocking(tmpBuf, false);
            }
        }
        catch (IOException | RuntimeException e) {
            if (buffer != null && buffer.refCnt() > 0) {
                buffer.release();
            }
            throw new IOException(e);
        }
    }

    public void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) {
        if (!this.committed) {
            this.committed = true;
            if (finished) {
                if (buffer == null) {
                    this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                } else {
                    this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)("" + buffer.readableBytes()));
                }
            } else if (!this.request.response().headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.request.response().setChunked(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end();
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            try {
                boolean bufferRequired;
                boolean bl = bufferRequired = this.awaitWriteable() || this.overflow != null && this.overflow.size() > 0;
                if (bufferRequired) {
                    this.registerDrainHandler();
                    if (this.overflow == null) {
                        this.overflow = new ByteArrayOutputStream();
                    }
                    if (data != null && data.hasArray()) {
                        this.overflow.write(data.array(), data.arrayOffset() + data.readerIndex(), data.readableBytes());
                    } else if (data != null) {
                        data.getBytes(data.readerIndex(), (OutputStream)this.overflow, data.readableBytes());
                    }
                    if (last) {
                        this.closed = true;
                    }
                    if (data != null) {
                        data.release();
                    }
                } else if (last) {
                    this.request.response().end(this.createBuffer(data));
                } else {
                    this.request.response().write((Object)this.createBuffer(data));
                }
            }
            catch (IOException | RuntimeException e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private boolean awaitWriteable() throws IOException {
        if (Context.isOnEventLoopThread()) {
            return this.request.response().writeQueueFull();
        }
        if (this.first) {
            this.first = false;
            return false;
        }
        assert (Thread.holdsLock(this.LOCK));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            this.registerDrainHandler();
            try {
                this.waitingForDrain = true;
                this.LOCK.wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
        return false;
    }

    private void registerDrainHandler() {
        if (!this.drainHandlerRegistered) {
            this.drainHandlerRegistered = true;
            Handler handler = event -> {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.waitingForDrain) {
                        this.LOCK.notifyAll();
                    }
                    if (this.overflow != null && this.overflow.size() > 0) {
                        if (this.closed) {
                            this.request.response().end(Buffer.buffer((byte[])this.overflow.toByteArray()));
                        } else {
                            this.request.response().write((Object)Buffer.buffer((byte[])this.overflow.toByteArray()));
                        }
                        this.overflow.reset();
                    }
                }
            };
            this.request.response().drainHandler(handler);
            this.request.response().closeHandler(handler);
        }
    }

    Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.pooledBuffer != null) {
            try {
                this.writeBlocking(this.pooledBuffer, false);
                this.pooledBuffer = null;
            }
            catch (IOException | RuntimeException e) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
                throw new IOException(e);
            }
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.pooledBuffer, true);
        }
        catch (IOException | RuntimeException e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
            this.pooledBuffer = null;
        }
    }

    public boolean isReady() {
        throw new UnsupportedOperationException();
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

