/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.HttpClientHTTPConduitFactory;
import io.quarkiverse.cxf.QuarkusClientFactoryBean;
import io.quarkiverse.cxf.QuarkusJaxWsProxyFactoryBean;
import io.quarkiverse.cxf.URLConnectionHTTPConduitFactory;
import io.quarkiverse.cxf.annotation.CXFClient;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.xml.ws.BindingProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.jboss.logging.Logger;

public abstract class CxfClientProducer {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProducer.class);
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_PACKAGE = "io.quarkiverse.cxf.runtime.proxy";
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME = "io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker";
    @Inject
    CxfConfig config;
    @Inject
    CxfFixedConfig fixedConfig;
    @Inject
    @Any
    Instance<ClientFactoryCustomizer> customizers;

    public Object loadCxfClient(InjectionPoint ip, CXFClientData meta) {
        return this.produceCxfClient(CxfClientProducer.selectorCXFClientInfo(this.config, this.fixedConfig, ip, meta));
    }

    public CXFClientInfo loadCxfClientInfo(InjectionPoint ip, CXFClientData meta) {
        return CxfClientProducer.selectorCXFClientInfo(this.config, this.fixedConfig, ip, meta);
    }

    private Object produceCxfClient(CXFClientInfo cxfClientInfo) {
        String trustStorePath;
        Class[] interfaces;
        Class<?> seiClass;
        String sei = cxfClientInfo.getSei();
        try {
            seiClass = Class.forName(sei, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.errorf("WebService interface (client) class %s not found", (Object)sei);
            return null;
        }
        try {
            Class[] classArray;
            if (cxfClientInfo.isProxyClassRuntimeInitialized()) {
                Class[] classArray2 = new Class[4];
                classArray2[0] = BindingProvider.class;
                classArray2[1] = Closeable.class;
                classArray2[2] = Client.class;
                classArray = classArray2;
                classArray2[3] = Class.forName(RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME, true, Thread.currentThread().getContextClassLoader());
            } else {
                Class[] classArray3 = new Class[3];
                classArray3[0] = BindingProvider.class;
                classArray3[1] = Closeable.class;
                classArray = classArray3;
                classArray3[2] = Client.class;
            }
            interfaces = classArray;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker", e);
        }
        QuarkusClientFactoryBean quarkusClientFactoryBean = new QuarkusClientFactoryBean();
        QuarkusJaxWsProxyFactoryBean factory = new QuarkusJaxWsProxyFactoryBean(quarkusClientFactoryBean, interfaces);
        factory.setServiceClass(seiClass);
        LOGGER.debugf("using servicename {%s}%s", (Object)cxfClientInfo.getWsNamespace(), (Object)cxfClientInfo.getWsName());
        factory.setServiceName(new QName(cxfClientInfo.getWsNamespace(), cxfClientInfo.getWsName()));
        if (cxfClientInfo.getEpName() != null) {
            factory.setEndpointName(new QName(cxfClientInfo.getEpNamespace(), cxfClientInfo.getEpName()));
        }
        factory.setAddress(cxfClientInfo.getEndpointAddress());
        if (cxfClientInfo.getSoapBinding() != null) {
            factory.setBindingId(cxfClientInfo.getSoapBinding());
        }
        if (cxfClientInfo.getWsdlUrl() != null && !cxfClientInfo.getWsdlUrl().isEmpty()) {
            factory.setWsdlURL(cxfClientInfo.getWsdlUrl());
        }
        if (cxfClientInfo.getUsername() != null) {
            factory.setUsername(cxfClientInfo.getUsername());
        }
        if (cxfClientInfo.getPassword() != null) {
            factory.setPassword(cxfClientInfo.getPassword());
        }
        String clientString = "client" + (String)(cxfClientInfo.getConfigKey() != null ? " " + cxfClientInfo.getConfigKey() : "");
        CXFRuntimeUtils.addBeans(cxfClientInfo.getFeatures(), "feature", clientString, sei, factory.getFeatures());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getHandlers(), "handler", clientString, sei, factory.getHandlers());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getInInterceptors(), "inInterceptor", clientString, sei, factory.getInInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getOutInterceptors(), "outInterceptor", clientString, sei, factory.getOutInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getOutFaultInterceptors(), "outFaultInterceptor", clientString, sei, factory.getOutFaultInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getInFaultInterceptors(), "inFaultInterceptor", clientString, sei, factory.getInFaultInterceptors());
        switch (cxfClientInfo.getHttpConduitImpl()) {
            case CXFDefault: {
                break;
            }
            case QuarkusCXFDefault: 
            case URLConnectionHTTPConduitFactory: {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put(HTTPConduitFactory.class.getName(), new URLConnectionHTTPConduitFactory());
                factory.setProperties(props);
                break;
            }
            case HttpClientHTTPConduitFactory: {
                HashMap<String, Object> props = new HashMap();
                props.put(HTTPConduitFactory.class.getName(), new HttpClientHTTPConduitFactory());
                factory.setProperties(props);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + CxfClientConfig.HTTPConduitImpl.class.getSimpleName() + " value: " + cxfClientInfo.getHttpConduitImpl());
            }
        }
        this.customizers.forEach(customizer -> customizer.customize(cxfClientInfo, factory));
        LOGGER.debug((Object)("cxf client loaded for " + sei));
        Object result = factory.create();
        HTTPConduit httpConduit = (HTTPConduit)ClientProxy.getClient((Object)result).getConduit();
        HTTPClientPolicy policy = httpConduit.getClient();
        policy.setConnectionTimeout(cxfClientInfo.getConnectionTimeout().longValue());
        policy.setReceiveTimeout(cxfClientInfo.getReceiveTimeout().longValue());
        policy.setConnectionRequestTimeout(cxfClientInfo.getConnectionRequestTimeout().longValue());
        policy.setAutoRedirect(cxfClientInfo.isAutoRedirect());
        policy.setMaxRetransmits(cxfClientInfo.getMaxRetransmits());
        policy.setAllowChunking(cxfClientInfo.isAllowChunking());
        policy.setChunkingThreshold(cxfClientInfo.getChunkingThreshold());
        policy.setChunkLength(cxfClientInfo.getChunkLength());
        Object value = cxfClientInfo.getAccept();
        if (value != null) {
            policy.setAccept((String)value);
        }
        if ((value = cxfClientInfo.getAcceptLanguage()) != null) {
            policy.setAcceptLanguage((String)value);
        }
        if ((value = cxfClientInfo.getAcceptEncoding()) != null) {
            policy.setAcceptEncoding((String)value);
        }
        if ((value = cxfClientInfo.getContentType()) != null) {
            policy.setContentType((String)value);
        }
        if ((value = cxfClientInfo.getHost()) != null) {
            policy.setHost((String)value);
        }
        policy.setConnection(cxfClientInfo.getConnection());
        value = cxfClientInfo.getCacheControl();
        if (value != null) {
            policy.setCacheControl((String)value);
        }
        policy.setVersion(cxfClientInfo.getVersion());
        value = cxfClientInfo.getBrowserType();
        if (value != null) {
            policy.setBrowserType((String)value);
        }
        if ((value = cxfClientInfo.getDecoupledEndpoint()) != null) {
            policy.setDecoupledEndpoint((String)value);
        }
        if ((value = cxfClientInfo.getProxyServer()) != null) {
            policy.setProxyServer((String)value);
        }
        if ((value = cxfClientInfo.getProxyServerPort()) != null) {
            policy.setProxyServerPort((Integer)value);
        }
        if ((value = cxfClientInfo.getNonProxyHosts()) != null) {
            policy.setNonProxyHosts((String)value);
        }
        policy.setProxyServerType(cxfClientInfo.getProxyServerType());
        String proxyUsername = cxfClientInfo.getProxyUsername();
        if (proxyUsername != null) {
            String proxyPassword = cxfClientInfo.getProxyPassword();
            ProxyAuthorizationPolicy proxyAuth = new ProxyAuthorizationPolicy();
            proxyAuth.setUserName(proxyUsername);
            proxyAuth.setPassword(proxyPassword);
            httpConduit.setProxyAuthorization(proxyAuth);
        }
        if ((trustStorePath = cxfClientInfo.getTrustStore()) != null) {
            TrustManagerFactory tmf;
            TLSClientParameters tlsCP = new TLSClientParameters();
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(trustStorePath);){
                KeyStore trustStore = KeyStore.getInstance(cxfClientInfo.getTrustStoreType());
                String pwd = cxfClientInfo.getTrustStorePassword();
                trustStore.load(is, pwd == null ? null : pwd.toCharArray());
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Could not load client-truststore.jks from class path", e);
            }
            tlsCP.setTrustManagers(tmf.getTrustManagers());
            String hostnameVerifierName = cxfClientInfo.getHostnameVerifier();
            if (hostnameVerifierName != null) {
                Optional<CxfClientConfig.WellKnownHostnameVerifier> wellKnownHostNameVerifierName = CxfClientConfig.WellKnownHostnameVerifier.of(hostnameVerifierName);
                if (wellKnownHostNameVerifierName.isPresent()) {
                    wellKnownHostNameVerifierName.get().configure(tlsCP);
                } else {
                    HostnameVerifier hostnameVerifier = (HostnameVerifier)CXFRuntimeUtils.getInstance(hostnameVerifierName, true);
                    if (hostnameVerifier == null) {
                        throw new RuntimeException("Could not find or instantiate " + hostnameVerifierName);
                    }
                    tlsCP.setHostnameVerifier(hostnameVerifier);
                }
            }
            httpConduit.setTlsClientParameters(tlsCP);
        }
        return result;
    }

    protected static CXFClientInfo selectorCXFClientInfo(CxfConfig config, CxfFixedConfig fixedConfig, InjectionPoint ip, CXFClientData meta) {
        if (ip.getAnnotated().isAnnotationPresent(CXFClient.class)) {
            CXFClient anno = (CXFClient)ip.getAnnotated().getAnnotation(CXFClient.class);
            String configKey = anno.value();
            if (config.isClientPresent(configKey)) {
                return new CXFClientInfo(meta, config.getClient(configKey), configKey);
            }
            if (configKey != null && !configKey.isEmpty()) {
                throw new IllegalStateException("quarkus.cxf.\"" + configKey + "\" is referenced in " + ip.getMember() + " but no such build time configuration entry exists");
            }
        }
        List keylist = fixedConfig.clients().entrySet().stream().filter(kv -> kv.getValue() != null).filter(kv -> ((CxfFixedConfig.ClientFixedConfig)kv.getValue()).serviceInterface().isPresent()).filter(kv -> ((CxfFixedConfig.ClientFixedConfig)kv.getValue()).serviceInterface().get().equals(meta.getSei())).filter(kv -> !((CxfFixedConfig.ClientFixedConfig)kv.getValue()).alternative()).map(Map.Entry::getKey).collect(Collectors.toList());
        switch (keylist.size()) {
            case 0: {
                LOGGER.warnf("No configuration found for quarkus.cxf.*.service-interface = %s and alternative = false. Using the values from the service instead: %s.", (Object)meta.getSei(), (Object)meta);
                return new CXFClientInfo(meta, config.internal().client(), null);
            }
            case 1: {
                return new CXFClientInfo(meta, config.clients().get(keylist.get(0)), (String)keylist.get(0));
            }
        }
        throw new IllegalStateException("quarkus.cxf.*.service-interface = " + meta.getSei() + " with alternative = false expected once, but found " + keylist.size() + " times in " + keylist.stream().map(k -> "quarkus.cxf.\"" + k + "\".service-interface").collect(Collectors.joining(", ")));
    }

    public static interface ClientFactoryCustomizer {
        public void customize(CXFClientInfo var1, JaxWsProxyFactoryBean var2);
    }
}

