/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.devui;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class CxfJsonRPCService {
    private static CXFServletInfos cxfServletInfos;

    public List<CXFServletInfo> getServices() {
        ArrayList<CXFServletInfo> servletInfos = cxfServletInfos != null ? new ArrayList<CXFServletInfo>(cxfServletInfos.getInfos()) : new ArrayList();
        servletInfos.sort(Comparator.comparing(CXFServletInfo::getSei));
        return servletInfos;
    }

    public List<CXFClientInfo> getClients() {
        ArrayList<CXFClientInfo> clientInfos = new ArrayList<CXFClientInfo>(CxfJsonRPCService.allClientInfos());
        clientInfos.sort(Comparator.comparing(CXFClientInfo::getSei));
        return clientInfos;
    }

    private static Collection<CXFClientInfo> allClientInfos() {
        return CDI.current().select(CXFClientInfo.class, new Annotation[0]).stream().collect(Collectors.toCollection(ArrayList::new));
    }

    public static void setServletInfos(CXFServletInfos infos) {
        if (cxfServletInfos == null) {
            cxfServletInfos = infos;
        }
    }
}

