/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.logging;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.LoggingConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.jboss.logging.Logger;

public class LoggingFactoryCustomizer {
    private static final Logger log = Logger.getLogger(LoggingFactoryCustomizer.class);
    private final CxfConfig config;
    private final LoggingFeature globalLoggingFeature;

    public LoggingFactoryCustomizer(CxfConfig config) {
        this.config = config;
        LoggingConfig.GlobalLoggingConfig globalLoggingConfig = config.logging();
        if (globalLoggingConfig.enabledFor().enabledForAny()) {
            this.globalLoggingFeature = this.configureLoggingFeature(globalLoggingConfig);
        } else {
            log.debugf("Global logging feature is disabled", new Object[0]);
            this.globalLoggingFeature = null;
        }
    }

    public void customize(CXFClientInfo cxfClientInfo, JaxWsProxyFactoryBean factory) {
        String key = cxfClientInfo.getConfigKey();
        if (key != null && Optional.ofNullable(this.config.clients()).map(m -> m.containsKey(key)).orElse(false).booleanValue()) {
            LoggingConfig.PerClientOrServiceLoggingConfig wssConfig = ((CxfClientConfig)Optional.ofNullable(this.config.clients()).map(m1 -> (CxfClientConfig)m1.get(key)).orElse(null)).logging();
            List features = factory.getFeatures();
            this.customize(Kind.client, key, wssConfig, features);
        }
    }

    public void customize(CXFServletInfo cxfServletInfo, JaxWsServerFactoryBean factory) {
        String key = cxfServletInfo.getRelativePath();
        if (key != null && Optional.ofNullable(this.config.endpoints()).map(m -> m.containsKey(key)).orElse(false).booleanValue()) {
            LoggingConfig.PerClientOrServiceLoggingConfig wssConfig = ((CxfEndpointConfig)Optional.ofNullable(this.config.endpoints()).map(m1 -> (CxfEndpointConfig)m1.get(key)).orElse(null)).logging();
            List features = factory.getFeatures();
            this.customize(Kind.endpoint, key, wssConfig, features);
        }
    }

    private void customize(Kind kind, String key, LoggingConfig.PerClientOrServiceLoggingConfig wssConfig, List<Feature> features) {
        LoggingFeature loggingFeature;
        Optional<Boolean> enabled = wssConfig.enabled();
        if (enabled.isPresent()) {
            loggingFeature = enabled.get() != false ? this.configureLoggingFeature(wssConfig) : null;
        } else if (this.config.logging().enabledFor().enabledForClients()) {
            loggingFeature = this.globalLoggingFeature;
            if (loggingFeature != null) {
                log.debugf("Logging feature not enabled explicitly for %s \"%s\", using the global logging feature", (Object)kind, (Object)key);
            }
        } else {
            loggingFeature = null;
            log.debugf("Logging feature not enabled explicitly for %s \"%s\", the global logging feature is not enabled for " + kind.name() + "s either", (Object)kind, (Object)key);
        }
        if (loggingFeature != null) {
            if (features.stream().anyMatch(i -> i instanceof LoggingFeature)) {
                throw new IllegalStateException(LoggingFeature.class.getSimpleName() + " already configured for " + kind + " \"" + key + "\". Either remove all quarkus.cxf." + kind + ".\"" + key + "\".logging.* options or the " + LoggingFeature.class.getSimpleName() + " you added programmatically or via quarkus.cxf." + kind + ".\"" + key + "\".features");
            }
            features.add((Feature)loggingFeature);
        }
    }

    private LoggingFeature configureLoggingFeature(LoggingConfig config) {
        LoggingFeature feature = new LoggingFeature();
        feature.setLimit(config.limit());
        feature.setInMemThreshold(config.inMemThreshold());
        feature.setPrettyLogging(config.pretty());
        feature.setLogBinary(config.logBinary());
        feature.setLogMultipart(config.logMultipart());
        feature.setVerbose(config.verbose());
        this.addList(config.inBinaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addInBinaryContentMediaTypes(arg_0));
        this.addList(config.outBinaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addOutBinaryContentMediaTypes(arg_0));
        this.addList(config.binaryContentMediaTypes(), arg_0 -> ((LoggingFeature)feature).addBinaryContentMediaTypes(arg_0));
        config.sensitiveElementNames().ifPresent(arg_0 -> ((LoggingFeature)feature).addSensitiveElementNames(arg_0));
        config.sensitiveProtocolHeaderNames().ifPresent(arg_0 -> ((LoggingFeature)feature).addSensitiveProtocolHeaderNames(arg_0));
        return feature;
    }

    private void addList(Optional<List<String>> source, Consumer<String> consumer) {
        source.ifPresent(list -> consumer.accept(list.stream().collect(Collectors.joining(";"))));
    }

    private static enum Kind {
        client,
        endpoint;

    }
}

