/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.transport.VertxDestination;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.jboss.logging.Logger;

public class VertxDestinationFactory
extends SoapTransportFactory
implements DestinationFactory {
    private static final Logger LOGGER = Logger.getLogger(VertxDestinationFactory.class);
    private static final DestinationRegistry registry = new DestinationRegistryImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRegistry() {
        DestinationRegistry destinationRegistry = registry;
        synchronized (destinationRegistry) {
            for (String path : new ArrayList(registry.getDestinationsPaths())) {
                registry.removeDestination(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        if (endpointInfo == null) {
            throw new IllegalArgumentException("EndpointInfo cannot be null");
        }
        DestinationRegistry destinationRegistry = registry;
        synchronized (destinationRegistry) {
            String endpointAddress = endpointInfo.getAddress();
            LOGGER.debug((Object)String.format("Looking for destination for address %s...", endpointAddress));
            Object d = registry.getDestinationForPath(endpointInfo.getAddress());
            if (d == null) {
                LOGGER.debug((Object)String.format("Creating VertxDestination for address %s...", endpointAddress));
                d = new VertxDestination(endpointInfo, bus, registry);
                registry.addDestination(d);
                d.finalizeConfig();
            }
            LOGGER.debug((Object)String.format("Destination for address %s is %s", endpointAddress, d));
            return d;
        }
    }

    public DestinationRegistry getDestinationRegistry() {
        return registry;
    }
}

