/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkus.arc.Unremovable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@Unremovable
public class CXFClientInfo {
    private static final String DEFAULT_EP_ADDR = "http://localhost:8080";
    private final String sei;
    private final String endpointAddress;
    private final String wsdlUrl;
    private final String soapBinding;
    private final String wsNamespace;
    private final String wsName;
    private final String epNamespace;
    private final String epName;
    private final String username;
    private final String password;
    private final boolean proxyClassRuntimeInitialized;
    private final List<String> inInterceptors = new ArrayList<String>();
    private final List<String> outInterceptors = new ArrayList<String>();
    private final List<String> outFaultInterceptors = new ArrayList<String>();
    private final List<String> inFaultInterceptors = new ArrayList<String>();
    private final List<String> features = new ArrayList<String>();
    private final List<String> handlers = new ArrayList<String>();
    private final long connectionTimeout;
    private final long receiveTimeout;
    private final long connectionRequestTimeout;
    private final boolean autoRedirect;
    private final int maxRetransmits;
    private final boolean allowChunking;
    private final int chunkingThreshold;
    private final int chunkLength;
    private final String accept;
    private final String acceptLanguage;
    private final String acceptEncoding;
    private final String contentType;
    private final String host;
    private final ConnectionType connection;
    private final String cacheControl;
    private final String version;
    private final String browserType;
    private final String decoupledEndpoint;
    private final String decoupledEndpointBase;
    private final String proxyServer;
    private final Integer proxyServerPort;
    private final String nonProxyHosts;
    private final ProxyServerType proxyServerType;
    private final String proxyUsername;
    private final String proxyPassword;
    private final String trustStore;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final String hostnameVerifier;
    private final CxfClientConfig.HTTPConduitImpl httpConduitImpl;
    private final String configKey;
    private final SchemaValidation.SchemaValidationType schemaValidationEnabledFor;
    private final boolean secureWsdlAccess;

    public CXFClientInfo(CXFClientData other, CxfConfig cxfConfig, CxfClientConfig config, String configKey) {
        Objects.requireNonNull(config);
        this.sei = other.getSei();
        this.soapBinding = config.soapBinding().orElse(other.getSoapBinding());
        this.wsName = other.getWsName();
        this.wsNamespace = other.getWsNamespace();
        this.proxyClassRuntimeInitialized = other.isProxyClassRuntimeInitialized();
        this.epNamespace = config.endpointNamespace().orElse(null);
        this.epName = config.endpointName().orElse(null);
        this.username = config.username().orElse(null);
        this.password = config.password().orElse(null);
        this.secureWsdlAccess = config.secureWsdlAccess();
        this.endpointAddress = config.clientEndpointUrl().orElse("http://localhost:8080/" + this.sei.toLowerCase());
        this.wsdlUrl = config.wsdlPath().orElse(null);
        this.addFeatures(config);
        this.addHandlers(config);
        this.addInterceptors(config);
        this.connectionTimeout = config.connectionTimeout();
        this.receiveTimeout = config.receiveTimeout();
        this.connectionRequestTimeout = config.connectionRequestTimeout();
        this.autoRedirect = config.autoRedirect();
        this.maxRetransmits = config.maxRetransmits();
        this.allowChunking = config.allowChunking();
        this.chunkingThreshold = config.chunkingThreshold();
        this.chunkLength = config.chunkLength();
        this.accept = config.accept().orElse(null);
        this.acceptLanguage = config.acceptLanguage().orElse(null);
        this.acceptEncoding = config.acceptEncoding().orElse(null);
        this.contentType = config.contentType().orElse(null);
        this.host = config.host().orElse(null);
        this.connection = config.connection();
        this.cacheControl = config.cacheControl().orElse(null);
        this.version = config.version();
        this.browserType = config.browserType().orElse(null);
        this.decoupledEndpoint = config.decoupledEndpoint().orElse(null);
        this.decoupledEndpointBase = cxfConfig.decoupledEndpointBase().orElse(null);
        this.proxyServer = config.proxyServer().orElse(null);
        this.proxyServerPort = config.proxyServerPort().orElse(null);
        this.nonProxyHosts = config.nonProxyHosts().orElse(null);
        this.proxyServerType = config.proxyServerType();
        this.proxyUsername = config.proxyUsername().orElse(null);
        this.proxyPassword = config.proxyPassword().orElse(null);
        this.trustStore = config.trustStore().orElse(null);
        this.trustStorePassword = config.trustStorePassword().orElse(null);
        this.trustStoreType = Objects.requireNonNull(config.trustStoreType(), "trustStoreType cannot be null");
        this.hostnameVerifier = config.hostnameVerifier().orElse(null);
        this.schemaValidationEnabledFor = config.schemaValidationEnabledFor().orElse(null);
        this.httpConduitImpl = CxfClientConfig.HTTPConduitImpl.fromOptional(config.httpConduitFactory(), CXFRecorder.isHc5Present(), "quarkus.cxf.client." + configKey + ".http-conduit-impl", null);
        this.configKey = configKey;
    }

    public String getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getSei() {
        return this.sei;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String getWsNamespace() {
        return this.wsNamespace;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getEpNamespace() {
        return this.epNamespace;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isProxyClassRuntimeInitialized() {
        return this.proxyClassRuntimeInitialized;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public List<String> getInInterceptors() {
        return this.inInterceptors;
    }

    public List<String> getOutInterceptors() {
        return this.outInterceptors;
    }

    public List<String> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public List<String> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    private CXFClientInfo addInterceptors(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.inInterceptors().isPresent()) {
            this.inInterceptors.addAll((Collection<String>)cxfEndPointConfig.inInterceptors().get());
        }
        if (cxfEndPointConfig.outInterceptors().isPresent()) {
            this.outInterceptors.addAll((Collection<String>)cxfEndPointConfig.outInterceptors().get());
        }
        if (cxfEndPointConfig.outFaultInterceptors().isPresent()) {
            this.outFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors().get());
        }
        if (cxfEndPointConfig.inFaultInterceptors().isPresent()) {
            this.inFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors().get());
        }
        return this;
    }

    private CXFClientInfo addFeatures(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.features().isPresent()) {
            this.features.addAll((Collection<String>)cxfEndPointConfig.features().get());
        }
        return this;
    }

    private CXFClientInfo addHandlers(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.handlers().isPresent()) {
            this.handlers.addAll((Collection<String>)cxfEndPointConfig.handlers().get());
        }
        return this;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Long getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    public int getMaxRetransmits() {
        return this.maxRetransmits;
    }

    public boolean isAllowChunking() {
        return this.allowChunking;
    }

    public int getChunkingThreshold() {
        return this.chunkingThreshold;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHost() {
        return this.host;
    }

    public ConnectionType getConnection() {
        return this.connection;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public String getDecoupledEndpointBase() {
        return this.decoupledEndpointBase;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ProxyServerType getProxyServerType() {
        return this.proxyServerType;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public CxfClientConfig.HTTPConduitImpl getHttpConduitImpl() {
        return this.httpConduitImpl;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public SchemaValidation.SchemaValidationType getSchemaValidationEnabledFor() {
        return this.schemaValidationEnabledFor;
    }

    public boolean isSecureWsdlAccess() {
        return this.secureWsdlAccess;
    }
}

