/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;

@ApplicationScoped
public class QuarkusHttpConduitConfigurer
implements HTTPConduitConfigurer {
    private final Map<String, List<Consumer<HTTPConduit>>> configurersByAddress = new ConcurrentHashMap<String, List<Consumer<HTTPConduit>>>();

    @PostConstruct
    void init() {
        BusFactory.getDefaultBus().setExtension((Object)this, HTTPConduitConfigurer.class);
    }

    public void configure(String name, String address, HTTPConduit conduit) {
        List<Consumer<HTTPConduit>> configurers = this.configurersByAddress.get(address);
        if (configurers != null) {
            configurers.forEach(configurer -> configurer.accept(conduit));
        }
    }

    public void addConfigurer(String address, Consumer<HTTPConduit> configurer) {
        this.configurersByAddress.compute(address, (k, v) -> {
            if (v == null) {
                v = new ArrayList<Consumer>();
            }
            v.add(configurer);
            return v;
        });
    }
}

