/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.ConnectionTypeConverter;
import io.quarkiverse.cxf.HttpClientHTTPConduitFactory;
import io.quarkiverse.cxf.LoggingConfig;
import io.quarkiverse.cxf.QuarkusHTTPConduitFactory;
import io.quarkiverse.cxf.URLConnectionHTTPConduitFactory;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpClientHTTPConduitFactory;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.List;
import java.util.Optional;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@ConfigGroup
public interface CxfClientConfig {
    @WithName(value="wsdl")
    public Optional<String> wsdlPath();

    public Optional<String> soapBinding();

    public Optional<String> clientEndpointUrl();

    public Optional<String> endpointNamespace();

    public Optional<String> endpointName();

    public Optional<String> username();

    public Optional<String> password();

    @WithDefault(value="false")
    public boolean secureWsdlAccess();

    public LoggingConfig.PerClientOrServiceLoggingConfig logging();

    public Optional<List<String>> features();

    public Optional<List<String>> handlers();

    public Optional<List<String>> inInterceptors();

    public Optional<List<String>> outInterceptors();

    public Optional<List<String>> outFaultInterceptors();

    public Optional<List<String>> inFaultInterceptors();

    @WithDefault(value="30000")
    public long connectionTimeout();

    @WithDefault(value="60000")
    public long receiveTimeout();

    @WithDefault(value="60000")
    public long connectionRequestTimeout();

    @WithDefault(value="false")
    public boolean autoRedirect();

    @WithDefault(value="-1")
    public int maxRetransmits();

    @WithDefault(value="true")
    public boolean allowChunking();

    @WithDefault(value="4096")
    public int chunkingThreshold();

    @WithDefault(value="-1")
    public int chunkLength();

    public Optional<String> accept();

    public Optional<String> acceptLanguage();

    public Optional<String> acceptEncoding();

    public Optional<String> contentType();

    public Optional<String> host();

    @WithDefault(value="Keep-Alive")
    @WithConverter(value=ConnectionTypeConverter.class)
    public ConnectionType connection();

    public Optional<String> cacheControl();

    @WithDefault(value="auto")
    public String version();

    public Optional<String> browserType();

    public Optional<String> decoupledEndpoint();

    public Optional<String> proxyServer();

    public Optional<Integer> proxyServerPort();

    public Optional<String> nonProxyHosts();

    @WithDefault(value="HTTP")
    public ProxyServerType proxyServerType();

    public Optional<String> proxyUsername();

    public Optional<String> proxyPassword();

    public Optional<HTTPConduitImpl> httpConduitFactory();

    public Optional<String> keyStore();

    public Optional<String> keyStorePassword();

    @WithDefault(value="JKS")
    public String keyStoreType();

    public Optional<String> keyPassword();

    public Optional<String> trustStore();

    public Optional<String> trustStorePassword();

    @WithDefault(value="JKS")
    public String trustStoreType();

    public Optional<String> hostnameVerifier();

    @WithName(value="schema-validation.enabled-for")
    public Optional<SchemaValidation.SchemaValidationType> schemaValidationEnabledFor();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum WellKnownHostnameVerifier {
        AllowAllHostnameVerifier{

            @Override
            public void configure(TLSClientParameters params) {
                params.setDisableCNCheck(true);
            }
        }
        ,
        HttpsURLConnectionDefaultHostnameVerifier{

            @Override
            public void configure(TLSClientParameters params) {
                params.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
            }
        };


        public abstract void configure(TLSClientParameters var1);

        public static Optional<WellKnownHostnameVerifier> of(String name) {
            if (name == null) {
                return Optional.empty();
            }
            for (WellKnownHostnameVerifier item : WellKnownHostnameVerifier.values()) {
                if (!item.name().equals(name)) continue;
                return Optional.of(item);
            }
            return Optional.empty();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HTTPConduitImpl {
        QuarkusCXFDefault{

            @Override
            public HTTPConduitFactory newHTTPConduitFactory() {
                HTTPConduitImpl impl = 1.findDefaultHTTPConduitImpl();
                return impl.newHTTPConduitFactory();
            }
        }
        ,
        CXFDefault{

            @Override
            public HTTPConduitFactory newHTTPConduitFactory() {
                return null;
            }
        }
        ,
        VertxHttpClientHTTPConduitFactory{

            @Override
            public HTTPConduitFactory newHTTPConduitFactory() {
                return new VertxHttpClientHTTPConduitFactory();
            }
        }
        ,
        HttpClientHTTPConduitFactory{

            @Override
            public HTTPConduitFactory newHTTPConduitFactory() {
                return new HttpClientHTTPConduitFactory();
            }
        }
        ,
        URLConnectionHTTPConduitFactory{

            @Override
            public HTTPConduitFactory newHTTPConduitFactory() {
                return new URLConnectionHTTPConduitFactory();
            }
        };


        public abstract HTTPConduitFactory newHTTPConduitFactory();

        public static HTTPConduitImpl findDefaultHTTPConduitImpl() {
            if (QuarkusHTTPConduitFactory.defaultHTTPConduitImpl == null) {
                String defaultName = System.getenv("QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY");
                QuarkusHTTPConduitFactory.defaultHTTPConduitImpl = defaultName == null || defaultName.isEmpty() ? URLConnectionHTTPConduitFactory : HTTPConduitImpl.valueOf(defaultName);
            }
            return QuarkusHTTPConduitFactory.defaultHTTPConduitImpl;
        }
    }
}

