/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.QuarkusJaxWsServerFactoryBean;
import io.quarkiverse.cxf.QuarkusRuntimeJaxWsServiceFactoryBean;
import io.quarkiverse.cxf.auth.AuthFaultOutInterceptor;
import io.quarkiverse.cxf.logging.LoggingFactoryCustomizer;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkiverse.cxf.transport.VertxHttpServletRequest;
import io.quarkiverse.cxf.transport.VertxHttpServletRequestXForwardedFilter;
import io.quarkiverse.cxf.transport.VertxHttpServletResponse;
import io.quarkiverse.cxf.transport.VertxServletConfig;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.jboss.logging.Logger;

public class CxfHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(CxfHandler.class);
    private final Bus bus;
    private final ClassLoader loader;
    private final String contextPath;
    private final String servletPath;
    private final ServletController controller;
    private final BeanContainer beanContainer;
    private final CurrentIdentityAssociation association;
    private final IdentityProviderManager identityProviderManager;
    private final CurrentVertxRequest currentVertxRequest;
    private final HttpConfiguration httpConfiguration;
    private final int outputBufferSize;
    private final int minChunkSize;
    private static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";

    public CxfHandler(CXFServletInfos cxfServletInfos, BeanContainer beanContainer, HttpConfiguration httpConfiguration, CxfFixedConfig fixedConfig) {
        LOGGER.trace((Object)"CxfHandler created");
        this.beanContainer = beanContainer;
        this.httpConfiguration = httpConfiguration;
        Instance identityAssociationInstance = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = identityAssociationInstance.isResolvable() ? (CurrentIdentityAssociation)identityAssociationInstance.get() : null;
        Instance identityProviderManagerInstance = CDI.current().select(IdentityProviderManager.class, new Annotation[0]);
        this.identityProviderManager = identityProviderManagerInstance.isResolvable() ? (IdentityProviderManager)identityProviderManagerInstance.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        this.bus = BusFactory.getDefaultBus();
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        this.outputBufferSize = fixedConfig.outputBufferSize();
        this.minChunkSize = fixedConfig.minChunkSize();
        LOGGER.trace((Object)"load destination");
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        VertxDestinationFactory destinationFactory = new VertxDestinationFactory();
        DestinationRegistry destinationRegistry = destinationFactory.getRegistry();
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/quarkus", (DestinationFactory)destinationFactory);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/quarkus", (ConduitInitiator)destinationFactory);
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(destinationRegistry, this.bus);
        VertxServletConfig servletConfig = new VertxServletConfig();
        serviceListGeneratorServlet.init((ServletConfig)servletConfig);
        this.controller = new ServletController(destinationRegistry, (ServletConfig)servletConfig, (HttpServlet)serviceListGeneratorServlet);
        this.servletPath = cxfServletInfos.getPath();
        this.contextPath = cxfServletInfos.getContextPath();
        LoggingFactoryCustomizer loggingFactoryCustomizer = new LoggingFactoryCustomizer((CxfConfig)CDI.current().select(CxfConfig.class, new Annotation[0]).get());
        Instance customizers = CDI.current().select(EndpointFactoryCustomizer.class, new Annotation[0]);
        for (CXFServletInfo servletInfo : cxfServletInfos.getInfos()) {
            String endpointString = "endpoint " + servletInfo.getPath();
            Object instanceService = servletInfo.lookupBean();
            if (instanceService != null) {
                Class<?> instanceType = servletInfo.getImplementor();
                QuarkusRuntimeJaxWsServiceFactoryBean jaxWsServiceFactoryBean = new QuarkusRuntimeJaxWsServiceFactoryBean(new JaxWsImplementorInfo(instanceType));
                QuarkusJaxWsServerFactoryBean jaxWsServerFactoryBean = new QuarkusJaxWsServerFactoryBean(jaxWsServiceFactoryBean, endpointString);
                jaxWsServerFactoryBean.setServiceClass(instanceType);
                jaxWsServerFactoryBean.setDestinationFactory((DestinationFactory)destinationFactory);
                jaxWsServerFactoryBean.setBus(this.bus);
                jaxWsServerFactoryBean.setProperties(new LinkedHashMap());
                String endpointType = servletInfo.getClassName();
                if (servletInfo.isProvider().booleanValue()) {
                    jaxWsServiceFactoryBean.setInvoker((Invoker)new JAXWSMethodInvoker(instanceService));
                }
                jaxWsServerFactoryBean.setServiceName(new QName(servletInfo.getServiceTargetNamespace(), servletInfo.getServiceName()));
                jaxWsServerFactoryBean.setAddress(servletInfo.getRelativePath());
                jaxWsServerFactoryBean.setServiceBean(instanceService);
                if (servletInfo.getWsdlPath() != null) {
                    jaxWsServerFactoryBean.setWsdlLocation(servletInfo.getWsdlPath());
                }
                CXFRuntimeUtils.addBeans(servletInfo.getFeatures(), "feature", endpointString, endpointType, jaxWsServerFactoryBean.getFeatures());
                CXFRuntimeUtils.addBeans(servletInfo.getHandlers(), "handler", endpointString, endpointType, jaxWsServerFactoryBean.getHandlers());
                CXFRuntimeUtils.addBeans(servletInfo.getInInterceptors(), "inInterceptor", endpointString, endpointType, jaxWsServerFactoryBean.getInInterceptors());
                CXFRuntimeUtils.addBeans(servletInfo.getOutInterceptors(), "outInterceptor", endpointString, endpointType, jaxWsServerFactoryBean.getOutInterceptors());
                CXFRuntimeUtils.addBeans(servletInfo.getOutFaultInterceptors(), "outFaultInterceptor", endpointString, endpointType, jaxWsServerFactoryBean.getOutFaultInterceptors());
                jaxWsServerFactoryBean.getOutFaultInterceptors().add(new AuthFaultOutInterceptor());
                CXFRuntimeUtils.addBeans(servletInfo.getInFaultInterceptors(), "inFaultInterceptor", endpointString, endpointType, jaxWsServerFactoryBean.getInFaultInterceptors());
                if (servletInfo.getSOAPBinding() != null) {
                    jaxWsServerFactoryBean.setBindingId(servletInfo.getSOAPBinding());
                }
                if (servletInfo.getEndpointUrl() != null) {
                    jaxWsServerFactoryBean.setPublishedEndpointUrl(servletInfo.getEndpointUrl());
                }
                loggingFactoryCustomizer.customize(servletInfo, jaxWsServerFactoryBean);
                customizers.forEach(customizer -> customizer.customize(servletInfo, jaxWsServerFactoryBean));
                Server service = jaxWsServerFactoryBean.create();
                SchemaValidation.SchemaValidationType value = servletInfo.getSchemaValidationEnabledFor();
                if (value != null) {
                    service.getEndpoint().getEndpointInfo().setProperty("schema-validation-type", (Object)value);
                }
                LOGGER.info((Object)(servletInfo.toString() + " available."));
                continue;
            }
            throw new IllegalStateException("Cannot initialize " + servletInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext event) {
        ClassLoaderUtils.ClassLoaderHolder origLoader;
        block7: {
            origLoader = null;
            Bus origBus = null;
            try {
                if (this.loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                }
                if (this.bus != null) {
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                }
                this.process(event);
                if (origBus == this.bus) break block7;
            }
            catch (Throwable throwable) {
                if (origBus != this.bus) {
                    BusFactory.setThreadDefaultBus(origBus);
                }
                if (origLoader != null) {
                    origLoader.reset();
                }
                throw throwable;
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
        if (origLoader != null) {
            origLoader.reset();
        }
    }

    private HttpServletRequest checkXForwardedHeaders(HttpServletRequest request) {
        String originalPort;
        String originalHost;
        String originalPrefix;
        String originalRemoteAddr;
        String originalProtocol;
        if (this.httpConfiguration.proxy.proxyAddressForwarding && Stream.of(originalProtocol = request.getHeader(X_FORWARDED_PROTO_HEADER), originalRemoteAddr = request.getHeader(X_FORWARDED_FOR_HEADER), originalPrefix = this.httpConfiguration.proxy.enableForwardedPrefix ? null : request.getHeader(this.httpConfiguration.proxy.forwardedPrefixHeader), originalHost = this.httpConfiguration.proxy.enableForwardedHost ? null : request.getHeader(this.httpConfiguration.proxy.forwardedHostHeader), originalPort = request.getHeader(X_FORWARDED_PORT_HEADER)).anyMatch(Objects::nonNull)) {
            return new VertxHttpServletRequestXForwardedFilter(request, originalProtocol, originalRemoteAddr, originalPrefix, originalHost, originalPort);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RoutingContext event) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)event.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, (IdentityProviderManager)this.identityProviderManager));
            }
        }
        this.currentVertxRequest.setCurrent(event);
        try {
            VertxHttpServletRequest req = new VertxHttpServletRequest(event, this.contextPath, this.servletPath);
            VertxHttpServletResponse resp = new VertxHttpServletResponse(event, this.outputBufferSize, this.minChunkSize);
            req = this.checkXForwardedHeaders(req);
            this.controller.invoke((HttpServletRequest)req, (HttpServletResponse)resp);
            resp.end();
        }
        catch (ServletException se) {
            LOGGER.warn((Object)"Internal server error", (Throwable)se);
            event.fail(500, (Throwable)se);
        }
        catch (RuntimeException re) {
            LOGGER.warn((Object)"Cannot list or instantiate web service", (Throwable)re);
            event.fail(404, (Throwable)re);
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }

    public static interface EndpointFactoryCustomizer {
        public void customize(CXFServletInfo var1, JaxWsServerFactoryBean var2);
    }
}

